/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.aspectj;

import java.util.Arrays;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.aspectj.BeforeAdviceMethodInvocationAdapter;
import org.apache.shiro.authz.aop.AnnotationsAuthorizingMethodInterceptor;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectjAnnotationsAuthorizingMethodInterceptor
extends AnnotationsAuthorizingMethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AspectjAnnotationsAuthorizingMethodInterceptor.class);

    protected void performBeforeInterception(JoinPoint aJoinPoint) throws Throwable {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("#### Invoking a method decorated with a Shiro annotation\n\tkind       : " + aJoinPoint.getKind() + "\n\tjoinPoint  : " + aJoinPoint + "\n\tannotations: " + Arrays.toString(((MethodSignature)aJoinPoint.getSignature()).getMethod().getAnnotations()) + "\n\ttarget     : " + aJoinPoint.getTarget());
        }
        BeforeAdviceMethodInvocationAdapter mi = BeforeAdviceMethodInvocationAdapter.createFrom(aJoinPoint);
        super.invoke((MethodInvocation)mi);
    }
}

