/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cdi;

import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.authz.aop.AuthenticatedAnnotationHandler;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.authz.aop.DenyAllAnnotationHandler;
import org.apache.shiro.authz.aop.GuestAnnotationHandler;
import org.apache.shiro.authz.aop.PermissionAnnotationHandler;
import org.apache.shiro.authz.aop.PermitAllAnnotationHandler;
import org.apache.shiro.authz.aop.RoleAnnotationHandler;
import org.apache.shiro.authz.aop.RolesAllowedAnnotationHandler;
import org.apache.shiro.authz.aop.UserAnnotationHandler;

class AopHelper {
    static final Map<Class<? extends Annotation>, Callable<AuthorizingAnnotationHandler>> autorizationAnnotationClasses = Map.of(RequiresPermissions.class, PermissionAnnotationHandler::new, RequiresRoles.class, RoleAnnotationHandler::new, RequiresUser.class, UserAnnotationHandler::new, RequiresGuest.class, GuestAnnotationHandler::new, RequiresAuthentication.class, AuthenticatedAnnotationHandler::new, RolesAllowed.class, RolesAllowedAnnotationHandler::new, PermitAll.class, PermitAllAnnotationHandler::new, DenyAll.class, DenyAllAnnotationHandler::new);

    static List<SecurityInterceptor> createSecurityInterceptors(Method method, Class<?> clazz) {
        ArrayList<SecurityInterceptor> result = new ArrayList<SecurityInterceptor>();
        if (AopHelper.isInterceptOnClassAnnotation(method.getModifiers())) {
            for (Class<? extends Annotation> ac : AopHelper.getAutorizationAnnotationClasses()) {
                Annotation annotationOnClass = clazz.getAnnotation(ac);
                if (annotationOnClass == null) continue;
                result.add(new SecurityInterceptor(annotationOnClass));
            }
        }
        for (Class<? extends Annotation> ac : AopHelper.getAutorizationAnnotationClasses()) {
            Annotation annotation = method.getAnnotation(ac);
            if (annotation == null) continue;
            result.add(new SecurityInterceptor(annotation));
        }
        return result;
    }

    static AuthorizingAnnotationHandler createHandler(Annotation annotation) {
        return autorizationAnnotationClasses.get(annotation.annotationType()).call();
    }

    private static boolean isInterceptOnClassAnnotation(int modifiers) {
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
    }

    private static Collection<Class<? extends Annotation>> getAutorizationAnnotationClasses() {
        return autorizationAnnotationClasses.keySet();
    }

    private AopHelper() {
    }

    static class SecurityInterceptor {
        private final AuthorizingAnnotationHandler handler;
        private final Annotation annotation;

        SecurityInterceptor(Annotation annotation) {
            this.annotation = annotation;
            this.handler = AopHelper.createHandler(annotation);
            if (this.handler == null) {
                throw new IllegalStateException("No handler for " + String.valueOf(annotation) + "annotation");
            }
        }

        void intercept() {
            this.handler.assertAuthorized(this.getAnnotation());
        }

        public SecurityInterceptor(AuthorizingAnnotationHandler handler, Annotation annotation) {
            this.handler = handler;
            this.annotation = annotation;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }
    }
}

