/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.cdi;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shiro.cdi.AnnotatedTypeWrapper;
import org.apache.shiro.cdi.ShiroSecurityExtension;
import org.apache.shiro.ee.cdi.ShiroFacesViewScoped;
import org.apache.shiro.ee.cdi.ShiroOmniViewScoped;
import org.apache.shiro.ee.cdi.ShiroScopeContext;
import org.apache.shiro.ee.cdi.ShiroSessionScoped;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;
import org.omnifaces.cdi.ViewScoped;

public class ShiroSessionScopeExtension
implements Extension,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<ShiroScopeContext> contexts = Stream.of(new ShiroScopeContext(ShiroSessionScoped.class, SessionScoped.class), new ShiroScopeContext(ShiroFacesViewScoped.class, jakarta.faces.view.ViewScoped.class), new ShiroScopeContext(ShiroOmniViewScoped.class, ViewScoped.class)).collect(Collectors.toList());

    public void addSessionListeners(Collection<SessionListener> sessionListeners, SecurityManager sm) {
        sessionListeners.add(new SessionListener(){

            public void onStart(Session session) {
                contexts.forEach(ctx -> ctx.onCreate(session));
            }

            public void onStop(Session session) {
                contexts.forEach(ctx -> ctx.onDestroy(session));
            }

            public void onExpiration(Session session) {
                this.onStop(session);
            }
        });
    }

    <T> void addSessionScoped(@Observes @WithAnnotations(value={SessionScoped.class}) ProcessAnnotatedType<T> pat) {
        pat.setAnnotatedType((AnnotatedType)new AnnotatedTypeWrapper(pat.getAnnotatedType(), true, Set.of(ShiroSessionScopedAnnotated.class.getDeclaredAnnotations()[0], ShiroSecurityExtension.ShiroSecureAnnotated.class.getDeclaredAnnotations()[0]), Set.of(SessionScopedAnnotated.class.getDeclaredAnnotations()[0])));
    }

    <T> void addFacesViewScoped(@Observes @WithAnnotations(value={jakarta.faces.view.ViewScoped.class}) ProcessAnnotatedType<T> pat) {
        pat.setAnnotatedType((AnnotatedType)new AnnotatedTypeWrapper(pat.getAnnotatedType(), true, Set.of(ShiroFacesViewScopedAnnotated.class.getDeclaredAnnotations()[0], ShiroSecurityExtension.ShiroSecureAnnotated.class.getDeclaredAnnotations()[0]), Set.of(FacesViewScopedAnnotated.class.getDeclaredAnnotations()[0])));
    }

    <T> void addOmniViewScoped(@Observes @WithAnnotations(value={ViewScoped.class}) ProcessAnnotatedType<T> pat) {
        pat.setAnnotatedType((AnnotatedType)new AnnotatedTypeWrapper(pat.getAnnotatedType(), true, Set.of(ShiroOmniViewScopedAnnotated.class.getDeclaredAnnotations()[0], ShiroSecurityExtension.ShiroSecureAnnotated.class.getDeclaredAnnotations()[0]), Set.of(OmniViewScopedAnnotated.class.getDeclaredAnnotations()[0])));
    }

    void addScope(@Observes BeforeBeanDiscovery event) {
        contexts.forEach(ctx -> event.addScope(ctx.getScope(), true, true));
    }

    void registerContext(@Observes AfterBeanDiscovery event) {
        contexts.forEach(arg_0 -> ((AfterBeanDiscovery)event).addContext(arg_0));
    }

    @ShiroSessionScoped
    private static class ShiroSessionScopedAnnotated
    implements Serializable {
        private ShiroSessionScopedAnnotated() {
        }
    }

    @SessionScoped
    private static class SessionScopedAnnotated
    implements Serializable {
        private SessionScopedAnnotated() {
        }
    }

    @ShiroFacesViewScoped
    private static class ShiroFacesViewScopedAnnotated
    implements Serializable {
        private ShiroFacesViewScopedAnnotated() {
        }
    }

    @jakarta.faces.view.ViewScoped
    private static class FacesViewScopedAnnotated
    implements Serializable {
        private FacesViewScopedAnnotated() {
        }
    }

    @ShiroOmniViewScoped
    private static class ShiroOmniViewScopedAnnotated
    implements Serializable {
        private ShiroOmniViewScopedAnnotated() {
        }
    }

    @ViewScoped
    private static class OmniViewScopedAnnotated
    implements Serializable {
        private OmniViewScopedAnnotated() {
        }
    }
}

