/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.ee.filters.AuthenticationFilterDelegate;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.ee.filters.Forms;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

public class FormAuthenticationFilter
extends org.apache.shiro.web.filter.authc.FormAuthenticationFilter {
    static final String LOGIN_PREDICATE_ATTR_NAME = "org.apache.shiro.ee.login-predicate";
    static final String LOGIN_WAITTIME_ATTR_NAME = "org.apache.shiro.ee.login-wait-time";
    static final String LOGIN_URL_ATTR_NAME = "org.apache.shiro.ee.login-url";
    static final Forms.FallbackPredicate NO_PREDICATE = (path, request) -> false;
    private final AuthenticationFilterDelegate delegate = new AuthenticationFilterDelegate(new Methods());

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        if (request instanceof HttpServletRequest) {
            Forms.FallbackPredicate loginFallbackType = (Forms.FallbackPredicate)request.getAttribute(LOGIN_PREDICATE_ATTR_NAME);
            FormResubmitSupport.redirectToSaved(WebUtils.toHttp((ServletRequest)request), WebUtils.toHttp((ServletResponse)response), loginFallbackType, "");
        }
        return false;
    }

    protected String getPathWithinApplication(ServletRequest request) {
        return FormAuthenticationFilter.getPathWithinApplication(request, () -> super.getPathWithinApplication(request));
    }

    static String getPathWithinApplication(ServletRequest request, Supplier<String> superMethod) {
        String origPath = (String)request.getAttribute("org.omnifaces.facesviews.original.servlet_path");
        if (origPath != null) {
            return origPath;
        }
        return superMethod.get();
    }

    public boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        return this.delegate.preHandle(request, response);
    }

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return this.delegate.isAccessAllowed(request, response, mappedValue);
    }

    public void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        this.delegate.redirectToLogin(request, response);
    }

    public boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        return this.delegate.isLoginRequest(request, response);
    }

    public boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        return this.delegate.onLoginFailure(token, e, request, response);
    }

    public void saveRequestAndRedirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        this.delegate.saveRequestAndRedirectToLogin(request, response);
    }

    public void saveRequest(ServletRequest request) {
        this.delegate.saveRequest(request);
    }

    public boolean isUseRemembered() {
        return this.delegate.isUseRemembered();
    }

    public void setUseRemembered(boolean useRemembered) {
        this.delegate.setUseRemembered(useRemembered);
    }

    public int getLoginFailedWaitTime() {
        return this.delegate.getLoginFailedWaitTime();
    }

    public void setLoginFailedWaitTime(int loginFailedWaitTime) {
        this.delegate.setLoginFailedWaitTime(loginFailedWaitTime);
    }

    public Forms.FallbackPredicate getLoginFallbackType() {
        return this.delegate.getLoginFallbackType();
    }

    public void setLoginFallbackType(Forms.FallbackPredicate loginFallbackType) {
        this.delegate.setLoginFallbackType(loginFallbackType);
    }

    public Forms.FallbackPredicate getLogoutFallbackType() {
        return this.delegate.getLogoutFallbackType();
    }

    public void setLogoutFallbackType(Forms.FallbackPredicate logoutFallbackType) {
        this.delegate.setLogoutFallbackType(logoutFallbackType);
    }

    private class Methods
    implements AuthenticationFilterDelegate.MethodsFromFilter {
        private Methods() {
        }

        @Override
        public Subject getSubject(ServletRequest request, ServletResponse response) {
            return FormAuthenticationFilter.super.getSubject(request, response);
        }

        @Override
        public boolean isLoginRequest(ServletRequest request, ServletResponse response) {
            return FormAuthenticationFilter.super.isLoginRequest(request, response);
        }

        @Override
        public boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
            return FormAuthenticationFilter.super.onLoginFailure(token, e, request, response);
        }

        @Override
        public String getLoginUrl() {
            return FormAuthenticationFilter.super.getLoginUrl();
        }

        @Override
        public boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
            return FormAuthenticationFilter.super.preHandle(request, response);
        }
    }
}

