/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.shiro.ee.cdi.ShiroScopeContext;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormResubmitSupportCookies {
    private static final Logger log = LoggerFactory.getLogger(FormResubmitSupportCookies.class);
    static final String DONT_ADD_ANY_MORE_COOKIES = "org.apache.shiro.no-more-cookies";

    static void addCookie(@NonNull HttpServletResponse response, ServletContext servletContext, @NonNull String cokieName, @NonNull String cookieValue, int maxAge) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (cokieName == null) {
            throw new NullPointerException("cokieName is marked non-null but is null");
        }
        if (cookieValue == null) {
            throw new NullPointerException("cookieValue is marked non-null but is null");
        }
        Cookie cookie = new Cookie(cokieName, cookieValue);
        cookie.setPath(servletContext.getContextPath());
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    static void deleteCookie(@NonNull HttpServletResponse response, ServletContext servletContext, @NonNull String cokieName) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (cokieName == null) {
            throw new NullPointerException("cokieName is marked non-null but is null");
        }
        Cookie cookieToDelete = new Cookie(cokieName, "tbd");
        cookieToDelete.setPath(servletContext.getContextPath());
        cookieToDelete.setMaxAge(0);
        response.addCookie(cookieToDelete);
    }

    static int getCookieAge(ServletRequest request, SecurityManager securityManager) {
        DefaultWebSessionManager nativeSessionManager = FormResubmitSupport.getNativeSessionManager(securityManager);
        if (nativeSessionManager != null) {
            return (int)Duration.ofMillis(nativeSessionManager.getGlobalSessionTimeout()).toSeconds();
        }
        try {
            return (int)Duration.ofMinutes(request.getServletContext().getSessionTimeout()).toSeconds();
        }
        catch (Throwable e) {
            return (int)Duration.ofHours(1L).toSeconds();
        }
    }

    static String getSessionCookieName(ServletContext context, SecurityManager securityManager) {
        if (!ShiroScopeContext.isWebContainerSessions(securityManager) && FormResubmitSupport.getNativeSessionManager(securityManager) != null) {
            return FormResubmitSupport.getNativeSessionManager(securityManager).getSessionIdCookie().getName();
        }
        return context.getSessionCookieConfig().getName() != null ? context.getSessionCookieConfig().getName() : "JSESSIONID";
    }

    static Map<String, String> transformCookieHeader(@NonNull List<String> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies is marked non-null but is null");
        }
        return cookies.stream().map(s -> s.split("[=;]")).collect(Collectors.toMap(k -> k[0], v -> ((String[])v).length > 1 ? v[1] : ""));
    }

    private FormResubmitSupportCookies() {
    }
}

