/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.listeners;

import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.shiro.cdi.annotations.CipherKeySupplier;
import org.apache.shiro.config.Ini;
import org.apache.shiro.crypto.cipher.AesCipherService;
import org.apache.shiro.ee.filters.FormAuthenticationFilter;
import org.apache.shiro.ee.filters.LogoutFilter;
import org.apache.shiro.ee.filters.SslFilter;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.web.config.WebIniSecurityManagerFactory;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.filter.mgt.DefaultFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Lazy;
import org.omnifaces.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniEnvironment
extends IniWebEnvironment {
    private static final Logger log = LoggerFactory.getLogger(IniEnvironment.class);
    private String otherConfigLocation;

    public IniEnvironment() {
        SecurityManagerFactory securityManagerFactory = new SecurityManagerFactory();
        securityManagerFactory.getReflectionBuilder().setAlternateObjectSupplier(Beans::getInstance);
        this.setSecurityManagerFactory(securityManagerFactory);
    }

    public void setConfigLocations(String[] configLocations) {
        if (configLocations.length == 2) {
            this.otherConfigLocation = configLocations[1];
            super.setConfigLocations(configLocations[0]);
        } else {
            super.setConfigLocations(configLocations);
        }
    }

    protected Ini getFrameworkIni() {
        if (this.otherConfigLocation != null) {
            return this.createIni(this.otherConfigLocation, true);
        }
        return super.getFrameworkIni();
    }

    private static class SecurityManagerFactory
    extends WebIniSecurityManagerFactory {
        private final Lazy<AesCipherService> cipherService = new Lazy(AesCipherService::new);

        private SecurityManagerFactory() {
        }

        protected Map<String, ?> createDefaults(Ini ini, Ini.Section mainSection) {
            Map defaults = super.createDefaults(ini, mainSection);
            try {
                SslFilter sslFilter = new SslFilter();
                defaults.replace(DefaultFilter.authc.name(), new FormAuthenticationFilter());
                defaults.replace(DefaultFilter.ssl.name(), sslFilter);
                defaults.replace(DefaultFilter.logout.name(), new LogoutFilter());
            }
            catch (Throwable e) {
                log.warn("unable to initialize filters", e);
            }
            return defaults;
        }

        protected SecurityManager createDefaultInstance() {
            return new DefaultWebSecurityManager(this::generateCipherKey);
        }

        private byte[] generateCipherKey() {
            CipherKeySupplier cipherKeySupplier;
            CipherKeySupplier cipherKeySupplier2 = cipherKeySupplier = Beans.getManager() == null ? null : (CipherKeySupplier)Beans.getReference(CipherKeySupplier.class, (Annotation[])new Annotation[0]);
            if (cipherKeySupplier == null || Utils.isBlank((String)((String)cipherKeySupplier.get()))) {
                return ((AesCipherService)this.cipherService.get()).generateNewKey().getEncoded();
            }
            return ((String)cipherKeySupplier.get()).getBytes(StandardCharsets.UTF_8);
        }
    }
}

