/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.ee.listeners.EnvironmentLoaderListener;
import org.apache.shiro.subject.Subject;
import org.omnifaces.exceptionhandler.ViewExpiredExceptionHandler;
import org.omnifaces.util.Faces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Forms {
    private static final Logger log = LoggerFactory.getLogger(Forms.class);

    public static void redirectToSaved(FallbackPredicate useFallbackPath, String fallbackPath) {
        FormResubmitSupport.redirectToSaved(Faces.getRequest(), Faces.getResponse(), useFallbackPath, fallbackPath, !EnvironmentLoaderListener.isFormResubmitDisabled(Faces.getRequest().getServletContext()));
    }

    public static void redirectToView() {
        FormResubmitSupport.redirectToView(Faces.getRequest(), Faces.getResponse());
    }

    public static void redirectToView(FallbackPredicate useFallbackPath, String fallbackPath) {
        FormResubmitSupport.redirectToView(Faces.getRequest(), Faces.getResponse(), useFallbackPath, fallbackPath);
    }

    public static void login(String username, String password, boolean rememberMe) {
        try {
            SecurityUtils.getSubject().login((AuthenticationToken)new UsernamePasswordToken(username, password, rememberMe));
            Forms.redirectToSaved((FallbackPredicate)Faces.getRequestAttribute((String)"org.apache.shiro.ee.login-predicate"), "");
        }
        catch (AuthenticationException e) {
            Faces.setFlashAttribute((String)"shiroLoginFailure", (Object)((Object)e));
            int loginFailedWaitTime = (Integer)Faces.getRequestAttribute((String)"org.apache.shiro.ee.login-wait-time");
            if (loginFailedWaitTime != 0) {
                TimeUnit.SECONDS.sleep(loginFailedWaitTime);
            }
            Forms.redirectToView();
        }
    }

    public static void loginFailed() {
        Faces.setFlashAttribute((String)"shiroLoginFailure", (Object)Faces.getRequestAttribute((String)"shiroLoginFailure"));
        Faces.removeRequestAttribute((String)"shiroLoginFailure");
        Forms.redirectToView();
    }

    public static void logout() {
        Forms.logout((FallbackPredicate)Faces.getRequestAttribute((String)"org.apache.shiro.ee.logout-predicate"), "");
    }

    public static void logout(FallbackPredicate useFallback, String fallbackPath) {
        Forms.logout(Faces.getRequest(), Faces.getResponse(), useFallback, fallbackPath);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response, FallbackPredicate useFallback, String fallbackPath) {
        if (!Boolean.TRUE.toString().equals(request.getHeader("org.apache.shiro.form-is-resubmitted"))) {
            SecurityUtils.getSubject().logout();
            FormResubmitSupport.redirectToView(request, response, useFallback, fallbackPath);
        }
    }

    public static boolean isLoggedIn() {
        Subject subject = SecurityUtils.getSubject();
        return subject.isAuthenticated() || subject.isRemembered();
    }

    public static boolean isSessionExpired() {
        return ViewExpiredExceptionHandler.wasViewExpired() || Boolean.parseBoolean(Faces.getRequestParameter((String)"org.apache.shiro.sessionExpired"));
    }

    private Forms() {
    }

    @FunctionalInterface
    public static interface FallbackPredicate {
        public boolean useFallback(String var1, HttpServletRequest var2);
    }

    @Named(value="authc")
    @ApplicationScoped
    public static class AuthenticationMethods {
        public void login() {
            if (this.isLoginFailure()) {
                Forms.loginFailed();
            } else if (!this.redirectIfLoggedIn()) {
                throw new IllegalStateException("Not enough context to log in, need username / password");
            }
        }

        public void login(String username, String password) {
            this.login(username, password, false);
        }

        public void login(String username, String password, boolean rememberMe) {
            Forms.login(username, password, rememberMe);
        }

        public void logout() {
            Forms.logout();
        }

        public boolean isLoggedIn() {
            return Forms.isLoggedIn();
        }

        public boolean redirectIfLoggedIn() {
            return this.redirectIfLoggedIn("");
        }

        public boolean redirectIfLoggedIn(String view) {
            if (this.isLoggedIn()) {
                Forms.redirectToView((FallbackPredicate)Faces.getRequestAttribute((String)"org.apache.shiro.ee.logout-predicate"), view);
                return true;
            }
            return false;
        }

        public boolean isSessionExpired() {
            return Forms.isSessionExpired();
        }

        public boolean isLoginFailure() {
            return Faces.getRequestAttribute((String)"shiroLoginFailure") != null || Faces.getFlashAttribute((String)"shiroLoginFailure") != null;
        }
    }
}

