/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.util;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class JakartaTransformer {
    private static final boolean jakarta = HttpServletRequest.class.getPackageName().startsWith("jakarta");
    private static final Pattern REPLACE_JAVA_WITH_JAKARTA_PATTERN = Pattern.compile("javax\\.(\\w+)\\.");

    public static String jakartify(String className) {
        return REPLACE_JAVA_WITH_JAKARTA_PATTERN.matcher(className).replaceAll(JakartaTransformer.isJakarta() ? "jakarta.$1." : "javax.$1.");
    }

    private JakartaTransformer() {
    }

    public static boolean isJakarta() {
        return jakarta;
    }
}

