/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.ee.cdi.ShiroScopeContext;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.ee.listeners.EnvironmentLoaderListener;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.session.mgt.WebSessionKey;
import org.apache.shiro.web.subject.WebSubjectContext;
import org.apache.shiro.web.util.WebUtils;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="ShiroFilter", urlPatterns={"/*"}, dispatcherTypes={DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ASYNC}, asyncSupported=true)
public class ShiroFilter
extends org.apache.shiro.web.servlet.ShiroFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShiroFilter.class);
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final Pattern HTTP_TO_HTTPS = Pattern.compile("^\\s*http(.*)");

    protected ServletRequest wrapServletRequest(HttpServletRequest request) {
        if (EnvironmentLoaderListener.isShiroEEDisabled(request.getServletContext())) {
            return super.wrapServletRequest(request);
        }
        return new WrappedRequest(request, this.getServletContext(), this.isHttpSessions());
    }

    protected ServletResponse prepareServletResponse(ServletRequest request, ServletResponse response, FilterChain chain) {
        if (EnvironmentLoaderListener.isShiroEEDisabled(request.getServletContext()) || !(request instanceof HttpServletRequest)) {
            return super.prepareServletResponse(request, response, chain);
        }
        return new WrappedResponse(WebUtils.toHttp((ServletResponse)response), request);
    }

    public void init() throws Exception {
        if (EnvironmentLoaderListener.isShiroEEDisabled(this.getServletContext())) {
            return;
        }
        super.init();
        try {
            ShiroScopeContext.addScopeSessionListeners(super.getSecurityManager());
        }
        catch (Throwable e) {
            log.warn("Unable to add scope session listeners", e);
        }
    }

    public void setSecurityManager(WebSecurityManager sm) {
        super.setSecurityManager((WebSecurityManager)new WrappedSecurityManager(sm));
    }

    protected void executeChain(ServletRequest request, ServletResponse response, FilterChain origChain) throws IOException, ServletException {
        if (EnvironmentLoaderListener.isShiroEEDisabled(this.getServletContext())) {
            origChain.doFilter(request, response);
        } else if (Boolean.TRUE.equals(request.getAttribute("org.apache.shiro.form-is-resubmitted")) && FormResubmitSupport.isPostRequest(request)) {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            request.removeAttribute("org.apache.shiro.form-is-resubmitted");
            String postData = FormResubmitSupport.getPostData(request);
            log.debug("Resubmitting Post Data: {}", (Object)postData);
            HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
            boolean rememberedAjaxResubmit = "partial/ajax".equals(httpRequest.getHeader("Faces-Request"));
            Optional.ofNullable(FormResubmitSupport.resubmitSavedForm(postData, Servlets.getRequestURLWithQueryString((HttpServletRequest)httpRequest), WebUtils.toHttp((ServletRequest)request), WebUtils.toHttp((ServletResponse)response), request.getServletContext(), rememberedAjaxResubmit)).ifPresent(url -> ShiroFilter.sendRedirect(response, url));
        } else {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            super.executeChain(request, response, origChain);
        }
    }

    private static void sendRedirect(ServletResponse response, String url) {
        WebUtils.toHttp((ServletResponse)response).sendRedirect(url);
    }

    private static class WrappedRequest
    extends ShiroHttpServletRequest {
        private final AtomicReference<Object> httpsNeeded = new AtomicReference();
        private final AtomicReference<Object> secureRequestURL = new AtomicReference();

        WrappedRequest(HttpServletRequest wrapped, ServletContext servletContext, boolean httpSessions) {
            super(wrapped, servletContext, httpSessions);
        }

        public Principal getUserPrincipal() {
            if (EnvironmentLoaderListener.isServletNoPrincipal(this.servletContext)) {
                return null;
            }
            return super.getUserPrincipal();
        }

        public String getScheme() {
            if (this.isHttpsNeeded()) {
                return "https";
            }
            return super.getScheme();
        }

        public StringBuffer getRequestURL() {
            if (this.isHttpsNeeded()) {
                return this.getSecureRequestURL();
            }
            return super.getRequestURL();
        }

        public boolean isSecure() {
            return super.isSecure() || this.isHttpsNeeded();
        }

        private boolean createHttpButNeedHttps() {
            return !"https".equalsIgnoreCase(super.getScheme()) && "https".equalsIgnoreCase(WebUtils.toHttp((ServletRequest)this.getRequest()).getHeader(ShiroFilter.X_FORWARDED_PROTO));
        }

        private StringBuffer httpsRequestURL() {
            return new StringBuffer(HTTP_TO_HTTPS.matcher(super.getRequestURL()).replaceFirst("https$1"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        private boolean isHttpsNeeded() {
            Object $value = this.httpsNeeded.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.httpsNeeded;
                synchronized (atomicReference) {
                    $value = this.httpsNeeded.get();
                    if ($value == null) {
                        boolean actualValue = this.createHttpButNeedHttps();
                        $value = actualValue;
                        this.httpsNeeded.set($value);
                    }
                }
            }
            return (Boolean)$value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        private StringBuffer getSecureRequestURL() {
            Object $value = this.secureRequestURL.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.secureRequestURL;
                synchronized (atomicReference) {
                    $value = this.secureRequestURL.get();
                    if ($value == null) {
                        StringBuffer actualValue = this.httpsRequestURL();
                        $value = actualValue == null ? this.secureRequestURL : actualValue;
                        this.secureRequestURL.set($value);
                    }
                }
            }
            return (StringBuffer)($value == this.secureRequestURL ? null : $value);
        }
    }

    private static class WrappedResponse
    extends HttpServletResponseWrapper {
        private final ServletRequest request;

        WrappedResponse(HttpServletResponse response, ServletRequest request) {
            super(response);
            this.request = request;
        }

        public void addCookie(Cookie cookie) {
            if (this.request.getAttribute("org.apache.shiro.no-more-cookies") != Boolean.TRUE) {
                super.addCookie(cookie);
            }
        }

        public void sendRedirect(String location) throws IOException {
            if (!Utils.startsWithOneOf((String)location, (String[])new String[]{"http://", "https://"}) && !EnvironmentLoaderListener.isShiroEERedirectDisabled(this.request.getServletContext())) {
                location = Servlets.getRequestDomainURL((HttpServletRequest)WebUtils.toHttp((ServletRequest)this.request)) + (String)location;
            }
            super.sendRedirect((String)location);
        }
    }

    static class WrappedSecurityManager
    implements WebSecurityManager,
    org.apache.shiro.mgt.WrappedSecurityManager {
        final WebSecurityManager wrapped;

        public Subject createSubject(SubjectContext context) {
            if (context instanceof WebSubjectContext && this.wrapped instanceof DefaultSecurityManager) {
                WebSubjectContext webContext = (WebSubjectContext)context;
                DefaultWebSecurityManager wsm = (DefaultWebSecurityManager)this.wrapped;
                Session session = null;
                try {
                    session = wsm.getSession((SessionKey)new WebSessionKey(webContext.getSessionId(), webContext.getServletRequest(), webContext.getServletResponse()));
                }
                catch (SessionException e) {
                    log.debug("Create Session Failed", (Throwable)e);
                }
                Subject newSubject = this.wrapped.createSubject(context);
                if (newSubject.isRemembered() && session == null && !FormResubmitSupport.isJSFClientStateSavingMethod(webContext.getServletRequest().getServletContext())) {
                    log.debug("Remembered Subject with new session {}", newSubject.getPrincipal());
                    webContext.getServletRequest().setAttribute("org.apache.shiro.form-is-resubmitted", (Object)Boolean.TRUE);
                }
                return newSubject;
            }
            return this.wrapped.createSubject(context);
        }

        public <SM extends SecurityManager> SM unwrap() {
            return (SM)this.wrapped;
        }

        @Generated
        public WrappedSecurityManager(WebSecurityManager wrapped) {
            this.wrapped = wrapped;
        }

        @Generated
        public boolean isHttpSessionMode() {
            return this.wrapped.isHttpSessionMode();
        }

        @Generated
        public Subject login(Subject arg0, AuthenticationToken arg1) throws AuthenticationException {
            return this.wrapped.login(arg0, arg1);
        }

        @Generated
        public void logout(Subject arg0) {
            this.wrapped.logout(arg0);
        }

        @Generated
        public AuthenticationInfo authenticate(AuthenticationToken arg0) throws AuthenticationException {
            return this.wrapped.authenticate(arg0);
        }

        @Generated
        public boolean isPermitted(PrincipalCollection arg0, String arg1) {
            return this.wrapped.isPermitted(arg0, arg1);
        }

        @Generated
        public boolean isPermitted(PrincipalCollection arg0, Permission arg1) {
            return this.wrapped.isPermitted(arg0, arg1);
        }

        @Generated
        public boolean[] isPermitted(PrincipalCollection arg0, String ... arg1) {
            return this.wrapped.isPermitted(arg0, arg1);
        }

        @Generated
        public boolean[] isPermitted(PrincipalCollection arg0, List<Permission> arg1) {
            return this.wrapped.isPermitted(arg0, arg1);
        }

        @Generated
        public boolean isPermittedAll(PrincipalCollection arg0, String ... arg1) {
            return this.wrapped.isPermittedAll(arg0, arg1);
        }

        @Generated
        public boolean isPermittedAll(PrincipalCollection arg0, Collection<Permission> arg1) {
            return this.wrapped.isPermittedAll(arg0, arg1);
        }

        @Generated
        public void checkPermission(PrincipalCollection arg0, String arg1) throws AuthorizationException {
            this.wrapped.checkPermission(arg0, arg1);
        }

        @Generated
        public void checkPermission(PrincipalCollection arg0, Permission arg1) throws AuthorizationException {
            this.wrapped.checkPermission(arg0, arg1);
        }

        @Generated
        public void checkPermissions(PrincipalCollection arg0, String ... arg1) throws AuthorizationException {
            this.wrapped.checkPermissions(arg0, arg1);
        }

        @Generated
        public void checkPermissions(PrincipalCollection arg0, Collection<Permission> arg1) throws AuthorizationException {
            this.wrapped.checkPermissions(arg0, arg1);
        }

        @Generated
        public boolean hasRole(PrincipalCollection arg0, String arg1) {
            return this.wrapped.hasRole(arg0, arg1);
        }

        @Generated
        public boolean[] hasRoles(PrincipalCollection arg0, List<String> arg1) {
            return this.wrapped.hasRoles(arg0, arg1);
        }

        @Generated
        public boolean hasAllRoles(PrincipalCollection arg0, Collection<String> arg1) {
            return this.wrapped.hasAllRoles(arg0, arg1);
        }

        @Generated
        public void checkRole(PrincipalCollection arg0, String arg1) throws AuthorizationException {
            this.wrapped.checkRole(arg0, arg1);
        }

        @Generated
        public void checkRoles(PrincipalCollection arg0, Collection<String> arg1) throws AuthorizationException {
            this.wrapped.checkRoles(arg0, arg1);
        }

        @Generated
        public void checkRoles(PrincipalCollection arg0, String ... arg1) throws AuthorizationException {
            this.wrapped.checkRoles(arg0, arg1);
        }

        @Generated
        public Session start(SessionContext arg0) {
            return this.wrapped.start(arg0);
        }

        @Generated
        public Session getSession(SessionKey arg0) throws SessionException {
            return this.wrapped.getSession(arg0);
        }
    }
}

