/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.faces.tags;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import java.io.IOException;
import org.apache.shiro.ee.faces.tags.SecureTagHandler;

public abstract class PermissionTagHandler
extends SecureTagHandler {
    private final TagAttribute name = this.getRequiredAttribute("name");

    public PermissionTagHandler(TagConfig config) {
        super(config);
    }

    private String getAttrValue(FaceletContext ctx, TagAttribute attr) {
        String value;
        if (attr.isLiteral()) {
            value = attr.getValue(ctx);
        } else {
            ValueExpression expression = attr.getValueExpression(ctx, String.class);
            value = (String)expression.getValue((ELContext)ctx);
        }
        return value;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        String perm = this.getAttrValue(ctx, this.name);
        if (this.showTagBody(perm)) {
            this.nextHandler.apply(ctx, parent);
        }
    }

    protected boolean isPermitted(String p) {
        return this.getSubject() != null && this.getSubject().isPermitted(p);
    }

    protected abstract boolean showTagBody(String var1);
}

