/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.net.HttpCookie;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shiro.ee.cdi.ShiroScopeContext;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.ee.listeners.EnvironmentLoaderListener;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormResubmitSupportCookies {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FormResubmitSupportCookies.class);
    static final String DONT_ADD_ANY_MORE_COOKIES = "org.apache.shiro.no-more-cookies";

    static void addCookie(@NonNull HttpServletResponse response, ServletContext servletContext, @NonNull String cookieName, @NonNull String cookieValue, int maxAge) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (cookieName == null) {
            throw new NullPointerException("cookieName is marked non-null but is null");
        }
        if (cookieValue == null) {
            throw new NullPointerException("cookieValue is marked non-null but is null");
        }
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath(servletContext.getContextPath());
        cookie.setMaxAge(maxAge);
        if (EnvironmentLoaderListener.isFormResubmitSecureCookies(servletContext)) {
            cookie.setSecure(true);
        }
        response.addCookie(cookie);
    }

    static void deleteCookie(@NonNull HttpServletResponse response, ServletContext servletContext, @NonNull String cookieName) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (cookieName == null) {
            throw new NullPointerException("cookieName is marked non-null but is null");
        }
        Cookie cookieToDelete = new Cookie(cookieName, "tbd");
        cookieToDelete.setPath(servletContext.getContextPath());
        cookieToDelete.setMaxAge(0);
        if (EnvironmentLoaderListener.isFormResubmitSecureCookies(servletContext)) {
            cookieToDelete.setSecure(true);
        }
        response.addCookie(cookieToDelete);
    }

    static int getCookieAge(ServletRequest request, SecurityManager securityManager) {
        DefaultWebSessionManager nativeSessionManager = FormResubmitSupport.getNativeSessionManager(securityManager);
        if (nativeSessionManager != null) {
            return (int)Duration.ofMillis(nativeSessionManager.getGlobalSessionTimeout()).toSeconds();
        }
        try {
            return (int)Duration.ofMinutes(request.getServletContext().getSessionTimeout()).toSeconds();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            log.debug("ServletContext.getSessionTimeout() not supported", (Throwable)noSuchMethodError);
            return (int)Duration.ofHours(1L).toSeconds();
        }
    }

    static String getSessionCookieName(ServletContext context, SecurityManager securityManager) {
        if (!ShiroScopeContext.isWebContainerSessions(securityManager) && FormResubmitSupport.getNativeSessionManager(securityManager) != null) {
            return FormResubmitSupport.getNativeSessionManager(securityManager).getSessionIdCookie().getName();
        }
        return context.getSessionCookieConfig().getName() != null ? context.getSessionCookieConfig().getName() : "JSESSIONID";
    }

    static Map<String, String> transformCookieHeader(@NonNull List<String> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies is marked non-null but is null");
        }
        return FormResubmitSupportCookies.cookieStreamFromHeader(cookies).collect(Collectors.toMap(HttpCookie::getName, HttpCookie::getValue));
    }

    static Stream<HttpCookie> cookieStreamFromHeader(@NonNull List<String> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies is marked non-null but is null");
        }
        return cookies.stream().map(HttpCookie::parse).map(list -> (HttpCookie)list.get(0));
    }

    @Generated
    private FormResubmitSupportCookies() {
    }
}

