/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.jaxrs;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.web.jaxrs.AnnotationAuthorizationFilter;

public class ShiroAnnotationFilterFeature
implements DynamicFeature {
    private static List<Class<? extends Annotation>> shiroAnnotations = Collections.unmodifiableList(Arrays.asList(RequiresPermissions.class, RequiresRoles.class, RequiresAuthentication.class, RequiresUser.class, RequiresGuest.class));

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ArrayList<Annotation> authzSpecs = new ArrayList<Annotation>();
        for (Class<? extends Annotation> annotationClass : shiroAnnotations) {
            Annotation classAuthzSpec = resourceInfo.getResourceClass().getAnnotation(annotationClass);
            Annotation methodAuthzSpec = resourceInfo.getResourceMethod().getAnnotation(annotationClass);
            if (classAuthzSpec != null) {
                authzSpecs.add(classAuthzSpec);
            }
            if (methodAuthzSpec == null) continue;
            authzSpecs.add(methodAuthzSpec);
        }
        if (!authzSpecs.isEmpty()) {
            context.register((Object)new AnnotationAuthorizationFilter(authzSpecs), 2000);
        }
    }
}

