/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.jaxrs;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.web.jaxrs.AnnotationAuthorizationFilter;

public class ShiroAnnotationFilterFeature
implements DynamicFeature {
    private static final List<Class<? extends Annotation>> shiroAnnotations = List.of(RequiresPermissions.class, RequiresRoles.class, RequiresAuthentication.class, RequiresUser.class, RequiresGuest.class);
    private static final List<Class<? extends Annotation>> jsr250Annotations = List.of(RolesAllowed.class, PermitAll.class, DenyAll.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ArrayList<Annotation> authzSpecs = new ArrayList<Annotation>();
        List<Class<Annotation>> annotations = shiroAnnotations;
        if (Boolean.TRUE.equals(context.getConfiguration().getProperty("org.apache.shiro.web.jaxrs.disable-principal"))) {
            annotations = Stream.concat(shiroAnnotations.stream(), jsr250Annotations.stream()).collect(Collectors.toList());
        }
        for (Class<? extends Annotation> annotationClass : annotations) {
            Annotation classAuthzSpec = resourceInfo.getResourceClass().getAnnotation(annotationClass);
            Annotation methodAuthzSpec = resourceInfo.getResourceMethod().getAnnotation(annotationClass);
            if (classAuthzSpec != null) {
                authzSpecs.add(classAuthzSpec);
            }
            if (methodAuthzSpec == null) continue;
            authzSpecs.add(methodAuthzSpec);
        }
        if (!authzSpecs.isEmpty()) {
            context.register((Object)new AnnotationAuthorizationFilter(authzSpecs), 2000);
        }
    }
}

