/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.lang.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.shiro.lang.io.ClassResolvingObjectInputStream;
import org.apache.shiro.lang.io.SerializationException;
import org.apache.shiro.lang.io.Serializer;

public class DefaultSerializer<T>
implements Serializer<T> {
    @Override
    public byte[] serialize(T o) throws SerializationException {
        if (o == null) {
            String msg = "argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.close();
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            String msg = "Unable to serialize object [" + String.valueOf(o) + "].  In order for the DefaultSerializer to serialize this object, the [" + o.getClass().getName() + "] class must implement java.io.Serializable.";
            throw new SerializationException(msg, e);
        }
    }

    @Override
    public T deserialize(byte[] serialized) throws SerializationException {
        if (serialized == null) {
            String msg = "argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        BufferedInputStream bis = new BufferedInputStream(bais);
        try {
            ClassResolvingObjectInputStream ois = new ClassResolvingObjectInputStream(bis);
            Object deserialized = ois.readObject();
            ois.close();
            return (T)deserialized;
        }
        catch (Exception e) {
            String msg = "Unable to deserialize argument byte array.";
            throw new SerializationException(msg, e);
        }
    }
}

