/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.lang.util;

import java.io.Closeable;
import java.io.IOException;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.ByteUtils;

public class ByteSourceWrapper
implements Closeable {
    private byte[] bytes;

    private ByteSourceWrapper(byte[] bytes) {
        this.bytes = bytes;
    }

    public static ByteSourceWrapper wrap(Object value) {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return new ByteSourceWrapper(bytes);
        }
        if (value instanceof ByteSource) {
            byte[] bytes = ((ByteSource)value).getBytes();
            return new ByteSourceWrapper(bytes);
        }
        throw new IllegalArgumentException();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void close() throws IOException {
        ByteUtils.wipe(this.bytes);
    }
}

