/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.lang.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.shiro.lang.util.ClassUtils;
import org.apache.shiro.lang.util.UnknownClassException;

public class ClassResolvingObjectInputStream
extends ObjectInputStream {
    public ClassResolvingObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        try {
            return ClassUtils.forName(osc.getName());
        }
        catch (UnknownClassException e) {
            throw new ClassNotFoundException("Unable to load ObjectStreamClass [" + String.valueOf(osc) + "]: ", e);
        }
    }
}

