/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authz;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodPermissionFilter
extends PermissionsAuthorizationFilter {
    private static final Logger log = LoggerFactory.getLogger(HttpMethodPermissionFilter.class);
    private final Map<String, String> httpMethodActions = new HashMap<String, String>();
    private static final String CREATE_ACTION = "create";
    private static final String READ_ACTION = "read";
    private static final String UPDATE_ACTION = "update";
    private static final String DELETE_ACTION = "delete";

    public HttpMethodPermissionFilter() {
        for (HttpMethodAction methodAction : HttpMethodAction.values()) {
            this.httpMethodActions.put(methodAction.name().toLowerCase(), methodAction.getAction());
        }
    }

    protected Map<String, String> getHttpMethodActions() {
        return this.httpMethodActions;
    }

    protected String getHttpMethodAction(ServletRequest request) {
        String method = ((HttpServletRequest)request).getMethod();
        return this.getHttpMethodAction(method);
    }

    protected String getHttpMethodAction(String method) {
        String lc = method.toLowerCase();
        String resolved = this.getHttpMethodActions().get(lc);
        return resolved != null ? resolved : method;
    }

    protected String[] buildPermissions(HttpServletRequest request, String[] configuredPerms, String action) {
        return this.buildPermissions(configuredPerms, action);
    }

    protected String[] buildPermissions(String[] configuredPerms, String action) {
        if (configuredPerms == null || configuredPerms.length <= 0 || !StringUtils.hasText((String)action)) {
            return configuredPerms;
        }
        String[] mappedPerms = new String[configuredPerms.length];
        for (int i = 0; i < configuredPerms.length; ++i) {
            mappedPerms[i] = configuredPerms[i] + ":" + action;
        }
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mappedPerms.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(mappedPerms[i]);
            }
            log.trace("MAPPED '{}' action to permission(s) '{}'", (Object)action, (Object)sb);
        }
        return mappedPerms;
    }

    @Override
    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        String[] perms = (String[])mappedValue;
        String action = this.getHttpMethodAction(request);
        String[] resolvedPerms = this.buildPermissions(perms, action);
        return super.isAccessAllowed(request, response, resolvedPerms);
    }

    private static enum HttpMethodAction {
        DELETE("delete"),
        GET("read"),
        HEAD("read"),
        MKCOL("create"),
        OPTIONS("read"),
        POST("create"),
        PUT("update"),
        TRACE("read");

        private final String action;

        private HttpMethodAction(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }
}

