/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.env;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.ini.IniFactorySupport;
import org.apache.shiro.lang.io.ResourceUtils;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.Factory;
import org.apache.shiro.lang.util.Initializable;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.web.config.IniFilterChainResolverFactory;
import org.apache.shiro.web.config.ShiroFilterConfiguration;
import org.apache.shiro.web.config.WebIniSecurityManagerFactory;
import org.apache.shiro.web.env.ResourceBasedWebEnvironment;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniWebEnvironment
extends ResourceBasedWebEnvironment
implements Initializable,
Destroyable {
    public static final String DEFAULT_WEB_INI_RESOURCE_PATH = "/WEB-INF/shiro.ini";
    public static final String FILTER_CHAIN_RESOLVER_NAME = "filterChainResolver";
    public static final String SHIRO_FILTER_CONFIG_NAME = "shiroFilter";
    private static final Logger LOGGER = LoggerFactory.getLogger(IniWebEnvironment.class);
    private Ini ini;
    private WebIniSecurityManagerFactory factory = new WebIniSecurityManagerFactory();

    public void init() {
        this.setIni(this.parseConfig());
        this.configure();
    }

    protected Ini parseConfig() {
        Ini ini = this.getIni();
        String[] configLocations = this.getConfigLocations();
        if (LOGGER.isWarnEnabled() && !CollectionUtils.isEmpty((Map)ini) && configLocations != null && configLocations.length > 0) {
            LOGGER.warn("Explicit INI instance has been provided, but configuration locations have also been specified.  The {} implementation does not currently support multiple Ini config, but this may be supported in the future. Only the INI instance will be used for configuration.", (Object)IniWebEnvironment.class.getName());
        }
        if (CollectionUtils.isEmpty((Map)ini)) {
            LOGGER.debug("Checking any specified config locations.");
            ini = this.getSpecifiedIni(configLocations);
        }
        if (CollectionUtils.isEmpty((Map)ini)) {
            LOGGER.debug("No INI instance or config locations specified.  Trying default config locations.");
            ini = this.getDefaultIni();
        }
        if (CollectionUtils.isEmpty((Map)(ini = this.mergeIni(this.getFrameworkIni(), ini)))) {
            String msg = "Shiro INI configuration was either not found or discovered to be empty/unconfigured.";
            throw new ConfigurationException(msg);
        }
        return ini;
    }

    protected void configure() {
        this.objects.clear();
        WebSecurityManager securityManager = this.createWebSecurityManager();
        this.setWebSecurityManager(securityManager);
        ShiroFilterConfiguration filterConfiguration = this.createFilterConfiguration();
        this.setShiroFilterConfiguration(filterConfiguration);
        FilterChainResolver resolver = this.createFilterChainResolver();
        if (resolver != null) {
            this.setFilterChainResolver(resolver);
        }
    }

    protected Ini getFrameworkIni() {
        return null;
    }

    protected Ini getSpecifiedIni(String[] configLocations) throws ConfigurationException {
        Ini ini = null;
        if (configLocations != null && configLocations.length > 0) {
            if (configLocations.length > 1) {
                LOGGER.warn("More than one Shiro .ini config location has been specified.  Only the first will be used for configuration as the {} implementation does not currently support multiple files.  This may be supported in the future however.", (Object)IniWebEnvironment.class.getName());
            }
            ini = this.createIni(configLocations[0], true);
        }
        return ini;
    }

    protected Ini mergeIni(Ini ini1, Ini ini2) {
        if (ini1 == null) {
            return ini2;
        }
        if (ini2 == null) {
            return ini1;
        }
        Ini iniResult = new Ini(ini1);
        iniResult.merge((Map)ini2);
        return iniResult;
    }

    protected Ini getDefaultIni() {
        Ini ini = null;
        String[] configLocations = this.getDefaultConfigLocations();
        if (configLocations != null) {
            for (String location : configLocations) {
                ini = this.createIni(location, false);
                if (CollectionUtils.isEmpty((Map)ini)) continue;
                LOGGER.debug("Discovered non-empty INI configuration at location '{}'.  Using for configuration.", (Object)location);
                break;
            }
        }
        return ini;
    }

    protected Ini createIni(String configLocation, boolean required) throws ConfigurationException {
        Ini ini = null;
        if (configLocation != null) {
            ini = this.convertPathToIni(configLocation, required);
        }
        if (required && CollectionUtils.isEmpty(ini)) {
            String msg = "Required configuration location '" + configLocation + "' does not exist or did not contain any INI configuration.";
            throw new ConfigurationException(msg);
        }
        return ini;
    }

    protected ShiroFilterConfiguration createFilterConfiguration() {
        return (ShiroFilterConfiguration)this.objects.get(SHIRO_FILTER_CONFIG_NAME);
    }

    protected FilterChainResolver createFilterChainResolver() {
        FilterChainResolver resolver = null;
        Ini ini = this.getIni();
        if (!CollectionUtils.isEmpty((Map)ini)) {
            Factory factory = (Factory)this.objects.get(FILTER_CHAIN_RESOLVER_NAME);
            if (factory instanceof IniFactorySupport) {
                IniFactorySupport iniFactory = (IniFactorySupport)factory;
                iniFactory.setIni(ini);
                iniFactory.setDefaults(this.objects);
            }
            resolver = (FilterChainResolver)factory.getInstance();
        }
        return resolver;
    }

    protected WebSecurityManager createWebSecurityManager() {
        Map<String, Object> defaults;
        Ini ini = this.getIni();
        if (!CollectionUtils.isEmpty((Map)ini)) {
            this.factory.setIni(ini);
        }
        if (!CollectionUtils.isEmpty(defaults = this.getDefaults())) {
            this.factory.setDefaults(defaults);
        }
        WebSecurityManager wsm = (WebSecurityManager)this.factory.getInstance();
        Map beans = this.factory.getBeans();
        if (!CollectionUtils.isEmpty((Map)beans)) {
            this.objects.putAll(beans);
        }
        return wsm;
    }

    protected String[] getDefaultConfigLocations() {
        return new String[]{DEFAULT_WEB_INI_RESOURCE_PATH, "classpath:shiro.ini"};
    }

    private Ini convertPathToIni(String path, boolean required) {
        Ini ini = null;
        if (StringUtils.hasText((String)path)) {
            InputStream is;
            block9: {
                is = null;
                if (!ResourceUtils.hasResourcePrefix((String)path)) {
                    is = this.getServletContextResourceStream(path);
                } else {
                    try {
                        is = ResourceUtils.getInputStreamForPath((String)path);
                    }
                    catch (IOException e) {
                        if (required) {
                            throw new ConfigurationException((Throwable)e);
                        }
                        if (!LOGGER.isDebugEnabled()) break block9;
                        LOGGER.debug("Unable to load optional path '" + path + "'.", (Throwable)e);
                    }
                }
            }
            if (is != null) {
                ini = new Ini();
                ini.load(is);
            } else if (required) {
                throw new ConfigurationException("Unable to load resource path '" + path + "'");
            }
        }
        return ini;
    }

    private InputStream getServletContextResourceStream(String path) {
        InputStream is = null;
        path = WebUtils.normalize(path);
        ServletContext sc = this.getServletContext();
        if (sc != null) {
            is = sc.getResourceAsStream(path);
        }
        return is;
    }

    public Ini getIni() {
        return this.ini;
    }

    public void setIni(Ini ini) {
        this.ini = ini;
    }

    protected Map<String, Object> getDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(FILTER_CHAIN_RESOLVER_NAME, (Object)new IniFilterChainResolverFactory());
        defaults.put(SHIRO_FILTER_CONFIG_NAME, new ShiroFilterConfiguration());
        return defaults;
    }

    protected WebIniSecurityManagerFactory getSecurityManagerFactory() {
        return this.factory;
    }

    protected void setSecurityManagerFactory(WebIniSecurityManagerFactory factory) {
        this.factory = factory;
    }
}

