/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.PathConfigProcessor;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.apache.shiro.web.util.WebUtils;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathMatchingFilter
extends AdviceFilter
implements PathConfigProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathMatchingFilter.class);
    private static final String DEFAULT_PATH_SEPARATOR = "/";
    protected PatternMatcher pathMatcher = new AntPathMatcher();
    protected Map<String, Object> appliedPaths = new LinkedHashMap<String, Object>();

    @Override
    public Filter processPathConfig(String path, String config) {
        String[] values = null;
        if (config != null) {
            values = StringUtils.split((String)config);
        }
        this.appliedPaths.put(path, values);
        return this;
    }

    protected String getPathWithinApplication(ServletRequest request) {
        return WebUtils.getPathWithinApplication(WebUtils.toHttp(request));
    }

    protected boolean pathsMatch(String path, ServletRequest request) {
        String requestURI = this.getPathWithinApplication(request);
        LOGGER.trace("Attempting to match pattern '{}' with current requestURI '{}'...", (Object)path, (Object)Encode.forHtml((String)requestURI));
        boolean match = this.pathsMatch(path, requestURI);
        if (!match) {
            if (requestURI != null && !DEFAULT_PATH_SEPARATOR.equals(requestURI) && requestURI.endsWith(DEFAULT_PATH_SEPARATOR)) {
                requestURI = requestURI.substring(0, requestURI.length() - 1);
            }
            if (path != null && !DEFAULT_PATH_SEPARATOR.equals(path) && path.endsWith(DEFAULT_PATH_SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            LOGGER.trace("Attempting to match pattern '{}' with current requestURI '{}'...", (Object)path, (Object)Encode.forHtml((String)requestURI));
            match = this.pathsMatch(path, requestURI);
        }
        return match;
    }

    protected boolean pathsMatch(String pattern, String path) {
        boolean matches = this.pathMatcher.matches(pattern, path);
        LOGGER.trace("Pattern [{}] matches path [{}] => [{}]", new Object[]{pattern, path, matches});
        return matches;
    }

    @Override
    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        if (this.appliedPaths == null || this.appliedPaths.isEmpty()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("appliedPaths property is null or empty.  This Filter will passthrough immediately.");
            }
            return true;
        }
        for (String path : this.appliedPaths.keySet()) {
            if (!this.pathsMatch(path, request)) continue;
            LOGGER.trace("Current requestURI matches pattern '{}'.  Determining filter chain execution...", (Object)path);
            Object config = this.appliedPaths.get(path);
            return this.isFilterChainContinued(request, response, path, config);
        }
        return true;
    }

    private boolean isFilterChainContinued(ServletRequest request, ServletResponse response, String path, Object pathConfig) throws Exception {
        if (this.isEnabled(request, response, path, pathConfig)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Filter '{}' is enabled for the current request under path '{}' with config [{}].  Delegating to subclass implementation for 'onPreHandle' check.", new Object[]{this.getName(), path, pathConfig});
            }
            return this.onPreHandle(request, response, pathConfig);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Filter '{}' is disabled for the current request under path '{}' with config [{}].  The next element in the FilterChain will be called immediately.", new Object[]{this.getName(), path, pathConfig});
        }
        return true;
    }

    protected boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return true;
    }

    protected boolean isEnabled(ServletRequest request, ServletResponse response, String path, Object mappedValue) throws Exception {
        return this.isEnabled(request, response);
    }
}

