/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.measure.Units;
import org.apache.sis.util.logging.WarningListeners;

public abstract class Decoder
implements Closeable {
    public final WarningListeners<?> listeners;
    public volatile boolean canceled;

    protected Decoder(WarningListeners<?> warningListeners) {
        Objects.requireNonNull(warningListeners);
        this.listeners = warningListeners;
    }

    public abstract void setSearchPath(String ... var1) throws IOException;

    public abstract String[] getSearchPath() throws IOException;

    public abstract String stringValue(String var1) throws IOException;

    public abstract Number numericValue(String var1) throws IOException;

    protected final Number parseNumber(String string) {
        int n = string.indexOf(32);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.listeners.warning(null, (Exception)numberFormatException);
            return null;
        }
    }

    public abstract Date dateValue(String var1) throws IOException;

    public final Unit<?> unitValue(String string) throws IOException {
        String string2 = this.stringValue(string);
        if (string2 != null) {
            try {
                return Units.valueOf((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.listeners.warning(null, (Exception)illegalArgumentException);
            }
        }
        return null;
    }

    public abstract Date[] numberToDate(String var1, Number ... var2) throws IOException;

    public String getId() throws IOException {
        return this.stringValue("_Id");
    }

    public String getTitle() throws IOException {
        return this.stringValue("_Title");
    }

    public abstract Variable[] getVariables() throws IOException;

    public abstract GridGeometry[] getGridGeometries() throws IOException;
}

