/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.coverage.Category;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.util.Numbers;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Convention {
    private static final LazySet<Convention> AVAILABLES = new LazySet(Convention.class);
    public static final Convention DEFAULT = new Convention();
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String[] RANGE_ATTRIBUTES = new String[]{"valid_range", "actual_range", "valid_min", "valid_max"};
    private static final String[] NODATA_ATTRIBUTES = new String[]{"_FillValue", "missing_value"};
    protected static final int FILL_VALUE_MASK = 1;
    protected static final int MISSING_VALUE_MASK = 2;
    protected static final String LONGITUDE_OF_PRIME_MERIDIAN = "longitude_of_prime_meridian";
    static final String NAME_SUFFIX = "_name";
    protected static final String ELLIPSOID_NAME = "reference_ellipsoid_name";
    protected static final String PRIME_MERIDIAN_NAME = "prime_meridian_name";
    protected static final String GEODETIC_DATUM_NAME = "horizontal_datum_name";
    protected static final String GEOGRAPHIC_CRS_NAME = "geographic_crs_name";
    protected static final String PROJECTED_CRS_NAME = "projected_crs_name";
    protected static final String CONVERSION_NAME = "conversion_name";
    protected static final String TOWGS84 = "towgs84";

    protected Convention() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Convention find(Decoder decoder) {
        Convention convention;
        Iterator iterator;
        LazySet<Convention> lazySet = AVAILABLES;
        synchronized (lazySet) {
            iterator = AVAILABLES.iterator();
            if (!iterator.hasNext()) {
                return DEFAULT;
            }
            convention = (Convention)iterator.next();
        }
        while (!convention.isApplicableTo(decoder)) {
            lazySet = AVAILABLES;
            synchronized (lazySet) {
                if (!iterator.hasNext()) {
                    convention = DEFAULT;
                    break;
                }
                convention = (Convention)iterator.next();
            }
        }
        return convention;
    }

    protected boolean isApplicableTo(Decoder decoder) {
        return false;
    }

    public String[] getSearchPath() {
        return (String[])SEARCH_PATH.clone();
    }

    public String mapAttributeName(String string, int n) {
        return n == 0 ? string : null;
    }

    public VariableRole roleOf(Variable variable) {
        if (variable.isCoordinateSystemAxis()) {
            return VariableRole.AXIS;
        }
        int n = variable.getNumDimensions();
        if (n == 1) {
            return VariableRole.FEATURE_PROPERTY;
        }
        if (n != 0) {
            DataType dataType = variable.getDataType();
            int n2 = 0;
            for (Dimension dimension : variable.getGridDimensions()) {
                if (dimension.length() < 2L) continue;
                ++n2;
            }
            if (n2 >= 2 && dataType.rasterDataType != null) {
                return VariableRole.COVERAGE;
            }
            if (n == 2 && dataType == DataType.CHAR) {
                return VariableRole.FEATURE_PROPERTY;
            }
        }
        return VariableRole.OTHER;
    }

    public String[] namesOfAxisVariables(Variable variable) {
        return null;
    }

    public String nameOfDimension(Variable variable, int n) {
        return variable.getAttributeAsString("dim" + n);
    }

    public double gridToDataIndices(Variable variable) {
        return variable.getAttributeAsDouble("resampling_interval");
    }

    public Set<Linearizer> linearizers(Decoder decoder) {
        return Collections.emptySet();
    }

    public Set<String> nameOfMappingNode(Variable variable) {
        String string = variable.getAttributeAsString("grid_mapping");
        return string != null ? Collections.singleton(string) : Collections.emptySet();
    }

    public Map<String, Object> projection(Node node) {
        String string = node.getAttributeAsString("grid_mapping_name");
        if (string == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("grid_mapping_name", string);
        block12: for (String string2 : node.getAttributeNames()) {
            try {
                Object object;
                String string3;
                switch (string3 = string2.toLowerCase(Locale.US)) {
                    case "grid_mapping_name": {
                        continue block12;
                    }
                    case "towgs84": {
                        Vector vector = node.getAttributeAsVector(string2);
                        if (vector == null || vector.size() < 3) continue block12;
                        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(CommonCRS.WGS84.datum(), null);
                        bursaWolfParameters.setValues(vector.doubleValues());
                        object = bursaWolfParameters;
                        break;
                    }
                    case "crs_wkt": {
                        continue block12;
                    }
                    default: {
                        if (string3.endsWith(NAME_SUFFIX) && (object = node.getAttributeAsString(string2)) == null || (object = node.getAttributeValue(string2)) == null) continue block12;
                        if (!(object instanceof Vector)) break;
                        object = ((Vector)object).doubleValues();
                    }
                }
                if (hashMap.putIfAbsent(string2, object) == null) continue;
                node.error(Convention.class, "projection", null, (short)25, string2);
            }
            catch (NumberFormatException numberFormatException) {
                node.decoder.illegalAttributeValue(string2, node.getAttributeAsString(string2), numberFormatException);
            }
        }
        return hashMap;
    }

    public MathTransform gridToCRS(Node node, MathTransform mathTransform) throws TransformException {
        return null;
    }

    public CommonCRS defaultHorizontalCRS(boolean bl) {
        return bl ? CommonCRS.SPHERE : CommonCRS.GRS1980;
    }

    public NumberRange<?> validRange(Variable variable) {
        Number number = null;
        Number number2 = null;
        Class clazz = null;
        for (String string : RANGE_ATTRIBUTES) {
            Vector vector = variable.getAttributeAsVector(string);
            if (vector != null) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        Number number3 = vector.get(i);
                        if (number3 instanceof Float) {
                            float f = ((Float)number3).floatValue();
                            if (f == Float.MAX_VALUE) {
                                number3 = Float.valueOf(Float.POSITIVE_INFINITY);
                            } else if (f == -3.4028235E38f) {
                                number3 = Float.valueOf(Float.NEGATIVE_INFINITY);
                            }
                        } else if (number3 instanceof Double) {
                            double d = (Double)number3;
                            if (d == Double.MAX_VALUE) {
                                number3 = Double.POSITIVE_INFINITY;
                            } else if (d == -1.7976931348623157E308) {
                                number3 = Double.NEGATIVE_INFINITY;
                            }
                        }
                        clazz = Numbers.widestClass(clazz, number3.getClass());
                        number = Numbers.cast(number, (Class)clazz);
                        number2 = Numbers.cast(number2, (Class)clazz);
                        number3 = Numbers.cast((Number)number3, (Class)clazz);
                        if (!(string.endsWith("max") || number != null && Convention.compare(number3, number) >= 0)) {
                            number = number3;
                        }
                        if (string.endsWith("min") || number2 != null && Convention.compare(number3, number2) <= 0) continue;
                        number2 = number3;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        variable.decoder.illegalAttributeValue(string, vector.stringValue(i), numberFormatException);
                    }
                }
            }
            if (number == null || number2 == null) continue;
            Class<?> clazz2 = variable.getAttributeType("scale_factor");
            Class<?> clazz3 = variable.getAttributeType("add_offset");
            byte by = Numbers.getEnumConstant(clazz);
            if ((clazz2 != null || clazz3 != null) && by >= variable.getDataType().number && by >= Math.max(Numbers.getEnumConstant(clazz2), Numbers.getEnumConstant(clazz3))) {
                MeasurementRange measurementRange = new MeasurementRange(clazz, number, true, number2, true, variable.getUnit());
                return measurementRange;
            }
            boolean bl = true;
            boolean bl2 = true;
            Set<Number> set = variable.getNodataValues().keySet();
            if (!set.isEmpty()) {
                double d = number.doubleValue();
                double d2 = number2.doubleValue();
                for (Number number4 : set) {
                    double d3 = number4.doubleValue();
                    bl &= d != d3;
                    bl2 &= d2 != d3;
                }
            }
            NumberRange numberRange = new NumberRange(clazz, number, bl, number2, bl2);
            return numberRange;
        }
        return null;
    }

    private static int compare(Number number, Number number2) {
        return ((Comparable)((Object)number)).compareTo((Comparable)((Object)number2));
    }

    public Map<Number, Object> nodataValues(Variable variable) {
        LinkedHashMap<Number, Object> linkedHashMap = new LinkedHashMap<Number, Object>();
        for (int i = 0; i < NODATA_ATTRIBUTES.length; ++i) {
            String string = NODATA_ATTRIBUTES[i];
            Vector vector = variable.getAttributeAsVector(string);
            if (vector == null) continue;
            int n = vector.size();
            for (int j = 0; j < n; ++j) {
                try {
                    linkedHashMap.merge(vector.get(j), 1 << i, (object, object2) -> (Integer)object | (Integer)object2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    variable.decoder.illegalAttributeValue(string, vector.stringValue(i), numberFormatException);
                }
            }
        }
        return linkedHashMap;
    }

    public TransferFunction transferFunction(Variable variable) {
        TransferFunction transferFunction = new TransferFunction();
        double d = variable.getAttributeAsDouble("scale_factor");
        double d2 = variable.getAttributeAsDouble("add_offset");
        if (!Double.isNaN(d)) {
            transferFunction.setScale(d);
        }
        if (!Double.isNaN(d2)) {
            transferFunction.setOffset(d2);
        }
        return transferFunction;
    }

    public Unit<?> getUnitFallback(Variable variable) throws ParserException {
        return null;
    }

    public int getVisibleBand() {
        return 0;
    }

    public Function<Category, Color[]> getColors(Variable variable) {
        return null;
    }
}

