/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;

public abstract class Node
extends NamedElement {
    protected final Decoder decoder;

    protected Node(Decoder decoder) {
        this.decoder = decoder;
    }

    public abstract Collection<String> getAttributeNames();

    public abstract Class<?> getAttributeType(String var1);

    protected abstract Object getAttributeValue(String var1);

    public final String getAttributeAsString(String string) {
        Object object = this.getAttributeValue(string);
        if (object == null || object instanceof String) {
            return (String)object;
        }
        String[] stringArray = Node.toArray(object);
        if (stringArray == null) {
            return object.toString();
        }
        String string2 = null;
        for (String string3 : stringArray) {
            if (string3 == null) continue;
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            if (string2.equals(string3)) continue;
            return null;
        }
        return string2;
    }

    public final CharSequence[] getAttributeAsStrings(String string, char c) {
        Object object = this.getAttributeValue(string);
        if (object != null) {
            CharSequence[] charSequenceArray = Node.toArray(object);
            if (charSequenceArray == null) {
                charSequenceArray = CharSequences.split((CharSequence)object.toString(), (char)c);
            }
            if (charSequenceArray.length != 0) {
                return charSequenceArray;
            }
        }
        return null;
    }

    private static String[] toArray(Object object) {
        int n;
        String[] stringArray;
        Vector vector;
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof Object[]) {
            vector = (Vector)object;
            stringArray = new String[((Object[])vector).length];
            for (n = 0; n < stringArray.length; ++n) {
                Vector vector2 = vector[n];
                if (vector2 == null) continue;
                stringArray[n] = vector2.toString();
            }
        } else if (object instanceof Vector) {
            vector = (Vector)object;
            stringArray = new String[vector.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = vector.stringValue(n);
            }
        } else {
            return null;
        }
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = Strings.trimOrNull((String)stringArray[n]);
            bl |= stringArray[n] != null;
        }
        return bl ? stringArray : null;
    }

    public final Number getAttributeAsNumber(String string) {
        Number number = null;
        Object object = this.getAttributeValue(string);
        if (object instanceof Number) {
            number = (Number)object;
        } else if (object instanceof String) {
            number = this.decoder.parseNumber(string, (String)object);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Number number2 = vector.get(i);
                if (number2 == null) continue;
                if (number == null) {
                    number = number2;
                    continue;
                }
                if (number.equals(number2)) continue;
                return null;
            }
        }
        return number;
    }

    public final double getAttributeAsDouble(String string) {
        Number number = this.getAttributeAsNumber(string);
        if (number == null) {
            return Double.NaN;
        }
        double d = number.doubleValue();
        float f = (float)d;
        if ((double)f == d) {
            d = DecimalFunctions.floatToDouble((float)f);
        }
        return d;
    }

    public final Vector getAttributeAsVector(String string) {
        Object object = this.getAttributeValue(string);
        if (object instanceof Vector) {
            return (Vector)object;
        }
        if (object instanceof Float) {
            return Vector.createForDecimal((float[])new float[]{((Float)object).floatValue()});
        }
        if (object instanceof Number) {
            return Vector.create((Object)new Number[]{(Number)object}, (boolean)false);
        }
        return null;
    }

    protected final Locale getLocale() {
        return this.decoder.listeners.getLocale();
    }

    protected final Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    final Errors errors() {
        return Errors.getResources((Locale)this.getLocale());
    }

    protected final void warning(Class<?> clazz, String string, short s, Object ... objectArray) {
        Node.warning(this.decoder.listeners, clazz, string, null, null, s, objectArray);
    }

    protected final void error(Class<?> clazz, String string, Exception exception, short s, Object ... objectArray) {
        Node.warning(this.decoder.listeners, clazz, string, exception, (IndexedResourceBundle)this.errors(), s, objectArray);
    }
}

