/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.awt.Color;
import java.awt.image.DataBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.BufferedGridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;

final class Raster
extends BufferedGridCoverage {
    private final int pixelStride;
    private final int[] bandOffsets;
    private final int visibleBand;
    private final String label;
    private final Function<Category, Color[]> colors;

    Raster(GridGeometry gridGeometry, List<SampleDimension> list, DataBuffer dataBuffer, String string, int n, int[] nArray, int n2, Function<Category, Color[]> function) {
        super(gridGeometry, list, dataBuffer);
        this.label = string;
        this.colors = function;
        this.pixelStride = n;
        this.bandOffsets = nArray;
        this.visibleBand = n2;
    }

    protected void configure(ImageRenderer imageRenderer) {
        if (this.bandOffsets != null) {
            imageRenderer.setInterleavedPixelOffsets(this.pixelStride, this.bandOffsets);
        }
        if (this.colors != null) {
            imageRenderer.setCategoryColors(this.colors);
        }
        imageRenderer.setVisibleBand(this.visibleBand);
    }
}

