/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.internal.MovingFeatures;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.AxisType;
import org.apache.sis.storage.netcdf.base.CRSBuilder;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.DiscreteSampling;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.base.VariableRole;
import org.apache.sis.util.Characters;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.Strings;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.util.FactoryException;
import org.opengis.util.NameFactory;

final class FeatureSet
extends DiscreteSampling {
    static final String TRAJECTORY = "trajectory";
    private static final int PAGE_SIZE = 512;
    private final Vector counts;
    private final Variable[] properties;
    private final Variable[] dynamicProperties;
    private final int referencingDimension;
    private final boolean isTrajectory;
    private final boolean hasTime;
    private final DefaultTemporalCRS timeCRS;
    private final DefaultFeatureType type;

    private FeatureSet(Decoder decoder, String name, Vector counts, Variable[] properties, Variable[] dynamicProperties, Map<AxisType, Variable> selectedAxes, boolean isTrajectory, boolean hasTime, DataStore lock) throws DataStoreException, IOException {
        super(decoder.geomlib, decoder.listeners, lock);
        this.counts = counts;
        this.properties = properties;
        this.dynamicProperties = dynamicProperties;
        this.referencingDimension = selectedAxes.size();
        this.isTrajectory = isTrajectory | this.referencingDimension == 0;
        this.hasTime = hasTime;
        FeatureTypeBuilder builder = new FeatureTypeBuilder((NameFactory)decoder.nameFactory, decoder.geomlib, decoder.listeners.getLocale());
        for (int i = this.getReferencingDimension(false); i < properties.length; ++i) {
            Variable v = properties[i];
            Class type = v.getEnumeration() != null ? String.class : v.getDataType().getClass(v.getNumDimensions() > 1);
            FeatureSet.describe(v, builder.addAttribute(type));
        }
        DefaultTemporalCRS timeCRS = null;
        if (this.referencingDimension != 0) {
            AttributeTypeBuilder geometry = builder.addAttribute(isTrajectory ? GeometryType.LINEAR : GeometryType.POINT);
            geometry.setName((CharSequence)TRAJECTORY).addRole(AttributeRole.DEFAULT_GEOMETRY);
            try {
                SingleCRS[] time = new SingleCRS[1];
                geometry.setCRS(CRSBuilder.assemble(decoder, selectedAxes.values(), time));
                if (time[0] instanceof TemporalCRS) {
                    timeCRS = DefaultTemporalCRS.castOrCopy((TemporalCRS)((TemporalCRS)time[0]));
                }
            }
            catch (FactoryException ex) {
                decoder.listeners.warning(decoder.resources().getString((short)11, decoder.getFilename(), name, ex.getLocalizedMessage()), (Exception)((Object)ex));
            }
            if (hasTime) {
                geometry.addCharacteristic(MovingFeatures.characteristic((timeCRS != null ? 1 : 0) != 0));
            }
        }
        this.timeCRS = timeCRS;
        for (int i = this.getReferencingDimension(true); i < dynamicProperties.length; ++i) {
            Variable v = dynamicProperties[i];
            Class<String> type = v.getEnumeration() != null || v.isString() ? String.class : Number.class;
            FeatureSet.describe(v, builder.addAttribute(type).setMaximumOccurs(Integer.MAX_VALUE));
        }
        name = Strings.toUpperCase((String)name, (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)false);
        this.type = builder.setName((CharSequence)name).build();
    }

    private static void describe(Variable variable, AttributeTypeBuilder<?> attribute) {
        Unit<?> unit;
        String name = variable.getName();
        attribute.setName((CharSequence)name);
        String desc = variable.getDescription();
        if (desc != null && !desc.equals(name)) {
            attribute.setDefinition((CharSequence)desc);
        }
        if ((unit = variable.getUnit()) != null) {
            attribute.setUnit(unit);
        }
        if ("trajectory_id".equalsIgnoreCase(variable.getAttributeAsString("cf_role"))) {
            attribute.addRole(AttributeRole.IDENTIFIER_COMPONENT);
        }
    }

    static FeatureSet[] create(Decoder decoder, DataStore lock) throws IOException, DataStoreException {
        assert (Thread.holdsLock(lock));
        ArrayList<FeatureSet> features = new ArrayList<FeatureSet>(3);
        HashMap<Dimension, Boolean> done = new HashMap<Dimension, Boolean>();
        for (Variable v : decoder.getVariables()) {
            String sampleDimName;
            if (v.getRole() != VariableRole.FEATURE_PROPERTY) continue;
            if (v.getNumDimensions() == 1 && v.getDataType().isInteger && (sampleDimName = v.getAttributeAsString("sample_dimension")) != null) {
                Dimension featureDimension = v.getGridDimensions().get(0);
                Dimension sampleDimension = decoder.findDimension(sampleDimName);
                if (sampleDimension != null) {
                    FeatureSet.addFeatureSet(features, decoder, v, featureDimension, sampleDimension, lock);
                    done.put(sampleDimension, Boolean.TRUE);
                } else {
                    decoder.listeners.warning(decoder.resources().getString((short)1, decoder.getFilename(), v.getName(), sampleDimName));
                }
                done.put(featureDimension, Boolean.TRUE);
                continue;
            }
            done.putIfAbsent(v.getGridDimensions().get(0), Boolean.FALSE);
        }
        for (Map.Entry entry : done.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            Dimension dimension = (Dimension)entry.getKey();
            FeatureSet.addFeatureSet(features, decoder, null, dimension, dimension, lock);
        }
        return (FeatureSet[])features.toArray(FeatureSet[]::new);
    }

    private static void addFeatureSet(List<FeatureSet> features, Decoder decoder, Variable counts, Dimension featureDimension, Dimension sampleDimension, DataStore lock) throws IOException, DataStoreException {
        String featureName = featureDimension.getName();
        if (featureName == null) {
            return;
        }
        boolean isTrajectory = !sampleDimension.equals(featureDimension);
        ArrayList<Variable> properties = new ArrayList<Variable>();
        ArrayList<Variable> dynamicProperties = isTrajectory ? new ArrayList<Variable>() : Collections.emptyList();
        EnumMap<AxisType, Variable> coordinates = new EnumMap<AxisType, Variable>(AxisType.class);
        EnumMap<AxisType, Variable> trajectory = new EnumMap<AxisType, Variable>(AxisType.class);
        for (Variable data : decoder.getVariables()) {
            Variable previous;
            boolean dynamic;
            if (data.equals(counts)) continue;
            if (featureName.equalsIgnoreCase(data.getName())) {
                if (!FeatureSet.isScalarOrString(data, featureDimension, decoder)) continue;
                properties.add(data);
                continue;
            }
            if (FeatureSet.isScalarOrString(data, featureDimension, null)) {
                properties.add(data);
                dynamic = false;
            } else {
                if (!isTrajectory || !FeatureSet.isScalarOrString(data, sampleDimension, null)) continue;
                dynamicProperties.add(data);
                dynamic = true;
            }
            AxisType axisType = AxisType.valueOf(data);
            if (axisType == null || (previous = (dynamic ? trajectory : coordinates).putIfAbsent(axisType, data)) == null) continue;
            decoder.listeners.warning(decoder.resources().getString((short)3, decoder.getFilename(), (Object)axisType, previous.getName(), data.getName()));
        }
        Reorder r = new Reorder();
        features.add(new FeatureSet(decoder, featureName, counts != null ? counts.read() : null, r.toArray(properties, coordinates, false), r.toArray(dynamicProperties, trajectory, true), r.selectedAxes, r.isTrajectory, r.hasTime, lock));
    }

    private static boolean isScalarOrString(Variable data, Dimension featureDimension, Decoder decoder) {
        int unexpectedDimension;
        List<Dimension> dimensions = null;
        switch (data.getNumDimensions()) {
            default: {
                unexpectedDimension = 2;
                break;
            }
            case 2: {
                if (data.getDataType() != DataType.CHAR) {
                    unexpectedDimension = 1;
                    break;
                }
            }
            case 1: {
                dimensions = data.getGridDimensions();
                if (featureDimension.equals(dimensions.get(0))) {
                    return true;
                }
                unexpectedDimension = 0;
                break;
            }
            case 0: {
                return false;
            }
        }
        if (decoder != null) {
            if (dimensions == null) {
                dimensions = data.getGridDimensions();
            }
            decoder.listeners.warning(decoder.resources().getString((short)2, decoder.getFilename(), data.getName(), featureDimension.getName(), dimensions.get(unexpectedDimension).getName()));
        }
        return false;
    }

    final int getReferencingDimension(boolean dynamic) {
        return this.isTrajectory ^ dynamic ? 0 : this.referencingDimension;
    }

    public DefaultFeatureType getType() {
        return this.type;
    }

    public OptionalLong getFeatureCount() {
        long length;
        if (this.counts != null) {
            return OptionalLong.of(this.counts.size());
        }
        if (this.properties.length != 0 && (length = this.properties[0].getGridDimensions().get(0).length()) >= 0L) {
            return OptionalLong.of(length);
        }
        return OptionalLong.empty();
    }

    static boolean isEmpty(Object value) {
        return value == null || "".equals(value) || value instanceof Float && ((Float)value).isNaN() || value instanceof Double && ((Double)value).isNaN();
    }

    static GridExtent extent(List<Dimension> dimensions, int numDim, long position, int length) {
        long[] lower = new long[numDim];
        long[] upper = new long[numDim];
        lower[--numDim] = position;
        upper[numDim] = Math.addExact(position, (long)length);
        for (int i = 0; i < numDim; ++i) {
            upper[i] = dimensions.get(numDim - i).length();
        }
        return new GridExtent(null, lower, upper, false);
    }

    public Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        try {
            return StreamSupport.stream(new Iter(), false);
        }
        catch (IOException e) {
            throw new DataStoreException(this.canNotReadFile(), (Throwable)e);
        }
    }

    private static final class Reorder {
        Map<AxisType, Variable> selectedAxes = Collections.emptyMap();
        boolean isTrajectory;
        boolean hasTime;

        Reorder() {
        }

        Variable[] toArray(List<Variable> properties, EnumMap<AxisType, Variable> coordinates, boolean dynamic) {
            Variable[] array = new Variable[properties.size()];
            if (this.selectedAxes.isEmpty() && coordinates.containsKey((Object)AxisType.X) && coordinates.containsKey((Object)AxisType.Y)) {
                int dim;
                this.isTrajectory = dynamic;
                this.selectedAxes = coordinates;
                this.hasTime = coordinates.containsKey((Object)AxisType.T);
                array = coordinates.values().toArray(array);
                int n = dim = coordinates.size();
                block0: for (Variable v : properties) {
                    int i = dim;
                    while (--i >= 0) {
                        if (array[i] != v) continue;
                        continue block0;
                    }
                    array[n++] = v;
                }
                assert (n == array.length);
            } else {
                array = properties.toArray(array);
            }
            return array;
        }
    }

    private final class Iter
    implements Spliterator<AbstractFeature> {
        private final int size;
        private int featureIndex;
        private int currentLowerIndex;
        private int currentUpperIndex;
        private final int propertyIndexOffset;
        private final List<?>[] propertyValues;
        private final String[] propertyNames;
        private long dynamicPropertyPosition;
        private final int geometryDimension;

        Iter() throws IOException, DataStoreException {
            this.size = (int)Math.min(FeatureSet.this.getFeatureCount().orElse(0L), Integer.MAX_VALUE);
            this.geometryDimension = FeatureSet.this.referencingDimension - (FeatureSet.this.hasTime ? 1 : 0);
            this.propertyIndexOffset = FeatureSet.this.getReferencingDimension(false);
            int n = FeatureSet.this.properties.length;
            this.propertyValues = new List[n];
            this.propertyNames = new String[n -= this.propertyIndexOffset];
            for (int i = 0; i < n; ++i) {
                this.propertyNames[i] = FeatureSet.this.properties[i + this.propertyIndexOffset].getName();
            }
            this.readNextPage();
        }

        private void readNextPage() throws IOException, DataStoreException {
            int length = Math.min(this.size - this.currentLowerIndex, 512);
            this.read(FeatureSet.this.properties, this.propertyIndexOffset, this.currentLowerIndex, length, this.propertyValues);
            this.currentUpperIndex = this.currentLowerIndex + length;
        }

        @Override
        public boolean tryAdvance(Consumer<? super AbstractFeature> action) {
            Vector[] coordinateValues;
            int length;
            AbstractFeature feature;
            block20: {
                Object geometry;
                block22: {
                    int offset;
                    block23: {
                        boolean isFloat;
                        block21: {
                            Vector vc;
                            Object[] c;
                            feature = FeatureSet.this.type.newInstance();
                            try {
                                boolean isEmpty;
                                List<?>[] values = this.propertyValues;
                                do {
                                    if (this.featureIndex >= this.currentUpperIndex) {
                                        if (this.featureIndex >= this.size) {
                                            return false;
                                        }
                                        this.currentLowerIndex = this.featureIndex;
                                        this.readNextPage();
                                    }
                                    offset = this.featureIndex - this.currentLowerIndex;
                                    length = FeatureSet.this.counts != null ? FeatureSet.this.counts.intValue(this.featureIndex) : 1;
                                    isEmpty = length == 0;
                                    for (int i = 0; i < this.propertyNames.length; ++i) {
                                        Object value = values[i + this.propertyIndexOffset].get(offset);
                                        if (FeatureSet.isEmpty(value)) continue;
                                        isEmpty = false;
                                        feature.setPropertyValue(this.propertyNames[i], value);
                                    }
                                    ++this.featureIndex;
                                } while (isEmpty);
                                int n = FeatureSet.this.dynamicProperties.length;
                                if (n != 0) {
                                    int i;
                                    List[] target = new List[n];
                                    this.read(FeatureSet.this.dynamicProperties, i, this.dynamicPropertyPosition, length, target);
                                    for (i = FeatureSet.this.getReferencingDimension(true); i < n; ++i) {
                                        feature.setPropertyValue(FeatureSet.this.dynamicProperties[i].getName(), (Object)target[i]);
                                    }
                                    if (FeatureSet.this.isTrajectory) {
                                        values = target;
                                    }
                                }
                                coordinateValues = new Vector[FeatureSet.this.referencingDimension];
                                System.arraycopy(values, 0, coordinateValues, 0, coordinateValues.length);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(FeatureSet.this.canNotReadFile(), e);
                            }
                            catch (DataStoreException e) {
                                throw new BackingStoreException(FeatureSet.this.canNotReadFile(), (Throwable)e);
                            }
                            boolean isEmpty = FeatureSet.this.isTrajectory;
                            isFloat = FeatureSet.this.factory.supportSinglePrecision();
                            for (Vector vc2 : coordinateValues) {
                                if (isEmpty) {
                                    isEmpty = vc2.isEmptyOrNaN();
                                }
                                if (!isFloat) continue;
                                isFloat = vc2.isSinglePrecision();
                            }
                            if (isEmpty) break block20;
                            if (!FeatureSet.this.isTrajectory) break block21;
                            int n = Math.multiplyExact(length, this.geometryDimension);
                            if (isFloat) {
                                c = new float[n];
                                for (int i = 0; i < n; ++i) {
                                    c[i] = coordinateValues[i % this.geometryDimension].floatValue(i / this.geometryDimension);
                                }
                                vc = Vector.create((Object)c, (boolean)false);
                            } else {
                                c = new double[n];
                                for (int i = 0; i < n; ++i) {
                                    c[i] = (float)coordinateValues[i % this.geometryDimension].doubleValue(i / this.geometryDimension);
                                }
                                vc = Vector.create((double[])c);
                            }
                            geometry = FeatureSet.this.factory.createPolyline(false, this.geometryDimension, new Vector[]{vc});
                            break block22;
                        }
                        if (!isFloat) break block23;
                        float x = coordinateValues[0].floatValue(offset);
                        float y = coordinateValues[0].floatValue(offset);
                        if (Float.isNaN(x) && Float.isNaN(y)) break block20;
                        geometry = FeatureSet.this.factory.createPoint(x, y);
                        break block22;
                    }
                    double x = coordinateValues[0].doubleValue(offset);
                    double y = coordinateValues[1].doubleValue(offset);
                    if (Double.isNaN(x) && Double.isNaN(y)) break block20;
                    geometry = FeatureSet.this.factory.createPoint(x, y);
                }
                feature.setPropertyValue(FeatureSet.TRAJECTORY, geometry);
            }
            if (FeatureSet.this.hasTime) {
                MovingFeatures.setTimes((AbstractAttribute)((AbstractAttribute)feature.getProperty(FeatureSet.TRAJECTORY)), (Vector)coordinateValues[this.geometryDimension], (DefaultTemporalCRS)FeatureSet.this.timeCRS);
            }
            action.accept((AbstractFeature)feature);
            this.dynamicPropertyPosition += (long)length;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read(Variable[] variables, int refdim, long position, int length, List<?>[] target) throws IOException, DataStoreException {
            GridExtent extent = FeatureSet.extent(null, 1, position, length);
            List<Dimension> textDimensions = null;
            GridExtent textExtent = null;
            Object object = FeatureSet.this.getSynchronizationLock();
            synchronized (object) {
                for (int i = 0; i < variables.length; ++i) {
                    Object value;
                    Variable p = variables[i];
                    if (p.getNumDimensions() > 1) {
                        List<Dimension> dimensions = p.getGridDimensions();
                        if (textExtent == null || !dimensions.equals(textDimensions)) {
                            textExtent = FeatureSet.extent(dimensions, dimensions.size(), position, length);
                            textDimensions = dimensions;
                        }
                        value = p.readAnyType(textExtent, null);
                    } else {
                        value = i >= refdim ? p.readAnyType(extent, null) : p.read(extent, null);
                    }
                    Map<Integer, String> enumeration = p.getEnumeration();
                    if (enumeration != null && value instanceof Vector) {
                        Object data = value;
                        String[] meanings = new String[data.size()];
                        for (int j = 0; j < meanings.length; ++j) {
                            String m = enumeration.get(data.intValue(j));
                            meanings[j] = m != null ? m : "";
                        }
                        value = Arrays.asList(meanings);
                    }
                    target[i] = value;
                }
            }
        }

        @Override
        public Spliterator<AbstractFeature> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.size - this.featureIndex;
        }

        @Override
        public int characteristics() {
            return 1360;
        }
    }
}

