/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.classic;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.Axis;
import org.apache.sis.storage.netcdf.base.AxisType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.classic.DimensionInfo;
import org.apache.sis.storage.netcdf.classic.VariableInfo;
import org.apache.sis.storage.netcdf.internal.Resources;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.UnmodifiableArrayList;

final class GridInfo
extends Grid {
    private final DimensionInfo[] domain;
    private final VariableInfo[] range;

    GridInfo(DimensionInfo[] domain, VariableInfo[] range) {
        this.domain = domain;
        this.range = range;
    }

    @Override
    protected Grid forDimensions(Dimension[] dimensions) {
        int i = 0;
        for (DimensionInfo required : this.domain) {
            do {
                if (i < dimensions.length) continue;
                return null;
            } while (!required.equals(dimensions[i++]));
        }
        return this;
    }

    private String getFilename() {
        for (VariableInfo info : this.range) {
            String filename = info.getFilename();
            if (filename == null) continue;
            return filename;
        }
        return null;
    }

    @Override
    public String getName() {
        return GridInfo.listNames(this.range, this.range.length, " ");
    }

    @Override
    public int getSourceDimensions() {
        return this.domain.length;
    }

    @Override
    protected List<Dimension> getDimensions() {
        return UnmodifiableArrayList.wrap((Object[])this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] axisNames) {
        if (axisNames != null) {
            block0: for (String name : axisNames) {
                for (VariableInfo axis : this.range) {
                    if (name.equalsIgnoreCase(axis.getName())) continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        TreeMap<VariableInfo, Integer> variables = new TreeMap<VariableInfo, Integer>();
        for (int i = 0; i < this.range.length; ++i) {
            VariableInfo v = this.range[i];
            if (variables.put(v, i) == null) continue;
            throw new DataStoreContentException(Resources.format((short)7, this.getFilename(), v.getName()));
        }
        Axis[] axes = new Axis[this.range.length];
        for (Map.Entry entry : variables.entrySet()) {
            int targetDim = (Integer)entry.getValue();
            VariableInfo axis = (VariableInfo)entry.getKey();
            int i = 0;
            DimensionInfo[] axisDomain = axis.dimensions;
            int[] indices = new int[axisDomain.length];
            int[] sizes = new int[axisDomain.length];
            block2: for (DimensionInfo dimension : axisDomain) {
                for (int sourceDim = 0; sourceDim < this.domain.length; ++sourceDim) {
                    if (this.domain[sourceDim] != dimension) continue;
                    indices[i] = sourceDim;
                    sizes[i++] = dimension.length;
                    continue block2;
                }
            }
            axes[targetDim] = new Axis(AxisType.abbreviation(axis), axis.getAttributeAsString("positive"), ArraysExt.resize((int[])indices, (int)i), ArraysExt.resize((int[])sizes, (int)i), axis);
        }
        return axes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.domain) ^ Arrays.hashCode(this.range);
    }

    public boolean equals(Object other) {
        if (other instanceof GridInfo) {
            GridInfo that = (GridInfo)other;
            return Arrays.equals(this.domain, that.domain) && Arrays.equals(this.range, that.range);
        }
        return false;
    }
}

