/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent;

import java.lang.instrument.Instrumentation;
import java.util.List;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.SnifferConfigInitializer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.AbstractClassEnhancePluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.EnhanceContext;
import org.apache.skywalking.apm.agent.core.plugin.InstrumentDebuggingClass;
import org.apache.skywalking.apm.agent.core.plugin.PluginBootstrap;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.PluginFinder;
import org.apache.skywalking.apm.agent.core.plugin.bootstrap.BootstrapInstrumentBoost;
import org.apache.skywalking.apm.agent.core.plugin.bytebuddy.CacheableTransformerDecorator;
import org.apache.skywalking.apm.agent.core.plugin.jdk9module.JDK9ModuleExporter;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.ByteBuddy;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.agent.builder.AgentBuilder;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.NamedElement;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.DynamicType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.utility.JavaModule;

public class SkyWalkingAgent {
    private static ILog LOGGER = LogManager.getLogger(SkyWalkingAgent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String agentArgs, Instrumentation instrumentation) throws PluginException {
        PluginFinder pluginFinder;
        try {
            SnifferConfigInitializer.initializeCoreConfig(agentArgs);
        }
        catch (Exception e) {
            LogManager.getLogger(SkyWalkingAgent.class).error(e, "SkyWalking agent initialized failure. Shutting down.", new Object[0]);
            return;
        }
        finally {
            LOGGER = LogManager.getLogger(SkyWalkingAgent.class);
        }
        try {
            pluginFinder = new PluginFinder(new PluginBootstrap().loadPlugins());
        }
        catch (AgentPackageNotFoundException ape) {
            LOGGER.error(ape, "Locate agent.jar failure. Shutting down.", new Object[0]);
            return;
        }
        catch (Exception e) {
            LOGGER.error(e, "SkyWalking agent initialized failure. Shutting down.", new Object[0]);
            return;
        }
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(Config.Agent.IS_OPEN_DEBUGGING_CLASS));
        AgentBuilder agentBuilder = new AgentBuilder.Default(byteBuddy).ignore(ElementMatchers.nameStartsWith("org.apache.skywalking.apm.dependencies.net.bytebuddy.").or(ElementMatchers.nameStartsWith("org.slf4j.")).or(ElementMatchers.nameStartsWith("org.groovy.")).or(ElementMatchers.nameContains("javassist")).or(ElementMatchers.nameContains(".asm.")).or(ElementMatchers.nameContains(".reflectasm.")).or(ElementMatchers.nameStartsWith("sun.reflect")).or(SkyWalkingAgent.allSkyWalkingAgentExcludeToolkit()).or(ElementMatchers.isSynthetic()));
        JDK9ModuleExporter.EdgeClasses edgeClasses = new JDK9ModuleExporter.EdgeClasses();
        try {
            agentBuilder = BootstrapInstrumentBoost.inject(pluginFinder, instrumentation, agentBuilder, edgeClasses);
        }
        catch (Exception e) {
            LOGGER.error(e, "SkyWalking agent inject bootstrap instrumentation failure. Shutting down.", new Object[0]);
            return;
        }
        try {
            agentBuilder = JDK9ModuleExporter.openReadEdge(instrumentation, agentBuilder, edgeClasses);
        }
        catch (Exception e) {
            LOGGER.error(e, "SkyWalking agent open read edge in JDK 9+ failure. Shutting down.", new Object[0]);
            return;
        }
        if (Config.Agent.IS_CACHE_ENHANCED_CLASS) {
            try {
                agentBuilder = agentBuilder.with(new CacheableTransformerDecorator(Config.Agent.CLASS_CACHE_MODE));
                LOGGER.info("SkyWalking agent class cache [{}] activated.", new Object[]{Config.Agent.CLASS_CACHE_MODE});
            }
            catch (Exception e) {
                LOGGER.error(e, "SkyWalking agent can't active class cache.", new Object[0]);
            }
        }
        agentBuilder.type(pluginFinder.buildMatch()).transform(new Transformer(pluginFinder)).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(new Listener()).installOn(instrumentation);
        try {
            ServiceManager.INSTANCE.boot();
        }
        catch (Exception e) {
            LOGGER.error(e, "Skywalking agent boot failure.", new Object[0]);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(ServiceManager.INSTANCE::shutdown, "skywalking service shutdown thread"));
    }

    private static ElementMatcher.Junction<NamedElement> allSkyWalkingAgentExcludeToolkit() {
        return ElementMatchers.nameStartsWith("org.apache.skywalking.").and(ElementMatchers.not(ElementMatchers.nameStartsWith("org.apache.skywalking.apm.toolkit.")));
    }

    private static class Listener
    implements AgentBuilder.Listener {
        private Listener() {
        }

        @Override
        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        @Override
        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            if (LOGGER.isDebugEnable()) {
                LOGGER.debug("On Transformation class {}.", typeDescription.getName());
            }
            InstrumentDebuggingClass.INSTANCE.log(dynamicType);
        }

        @Override
        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        @Override
        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            LOGGER.error("Enhance class " + typeName + " error.", throwable);
        }

        @Override
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }
    }

    private static class Transformer
    implements AgentBuilder.Transformer {
        private PluginFinder pluginFinder;

        Transformer(PluginFinder pluginFinder) {
            this.pluginFinder = pluginFinder;
        }

        @Override
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            List<AbstractClassEnhancePluginDefine> pluginDefines = this.pluginFinder.find(typeDescription);
            if (pluginDefines.size() > 0) {
                DynamicType.Builder<?> newBuilder = builder;
                EnhanceContext context = new EnhanceContext();
                for (AbstractClassEnhancePluginDefine define : pluginDefines) {
                    DynamicType.Builder<?> possibleNewBuilder = define.define(typeDescription, newBuilder, classLoader, context);
                    if (possibleNewBuilder == null) continue;
                    newBuilder = possibleNewBuilder;
                }
                if (context.isEnhanced()) {
                    LOGGER.debug("Finish the prepare stage for {}.", typeDescription.getName());
                }
                return newBuilder;
            }
            LOGGER.debug("Matched class {}, but ignore by finding mechanism.", typeDescription.getTypeName());
            return builder;
        }
    }
}

