/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceIds;
import org.apache.skywalking.apm.agent.core.context.ids.GlobalIdGenerator;
import org.apache.skywalking.apm.agent.core.context.ids.NewDistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegmentRef;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;

public class TraceSegment {
    private String traceSegmentId = GlobalIdGenerator.generate();
    private List<TraceSegmentRef> refs;
    private List<AbstractTracingSpan> spans = new LinkedList<AbstractTracingSpan>();
    private DistributedTraceIds relatedGlobalTraces = new DistributedTraceIds();
    private boolean ignore = false;
    private boolean isSizeLimited = false;
    private final long createTime;

    public TraceSegment() {
        this.relatedGlobalTraces.append(new NewDistributedTraceId());
        this.createTime = System.currentTimeMillis();
    }

    public void ref(TraceSegmentRef refSegment) {
        if (this.refs == null) {
            this.refs = new LinkedList<TraceSegmentRef>();
        }
        if (!this.refs.contains(refSegment)) {
            this.refs.add(refSegment);
        }
    }

    public void relatedGlobalTraces(DistributedTraceId distributedTraceId) {
        this.relatedGlobalTraces.append(distributedTraceId);
    }

    public void archive(AbstractTracingSpan finishedSpan) {
        this.spans.add(finishedSpan);
    }

    public TraceSegment finish(boolean isSizeLimited) {
        this.isSizeLimited = isSizeLimited;
        return this;
    }

    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    public boolean hasRef() {
        return this.refs != null && this.refs.size() != 0;
    }

    public List<TraceSegmentRef> getRefs() {
        return this.refs;
    }

    public List<DistributedTraceId> getRelatedGlobalTraces() {
        return this.relatedGlobalTraces.getRelatedGlobalTraces();
    }

    public boolean isSingleSpanSegment() {
        return this.spans != null && this.spans.size() == 1;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public SegmentObject transform() {
        SegmentObject.Builder traceSegmentBuilder = SegmentObject.newBuilder();
        traceSegmentBuilder.setTraceId(this.getRelatedGlobalTraces().get(0).getId());
        traceSegmentBuilder.setTraceSegmentId(this.traceSegmentId);
        for (AbstractTracingSpan span : this.spans) {
            traceSegmentBuilder.addSpans(span.transform());
        }
        traceSegmentBuilder.setService(Config.Agent.SERVICE_NAME);
        traceSegmentBuilder.setServiceInstance(Config.Agent.INSTANCE_NAME);
        traceSegmentBuilder.setIsSizeLimited(this.isSizeLimited);
        return traceSegmentBuilder.build();
    }

    public String toString() {
        return "TraceSegment{traceSegmentId='" + this.traceSegmentId + '\'' + ", refs=" + this.refs + ", spans=" + this.spans + ", relatedGlobalTraces=" + this.relatedGlobalTraces + '}';
    }

    public long createTime() {
        return this.createTime;
    }
}

