/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.sampling;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.dynamic.ConfigurationDiscoveryService;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.sampling.SamplingRateWatcher;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class SamplingService
implements BootService {
    private static final ILog LOGGER = LogManager.getLogger(SamplingService.class);
    private volatile boolean on = false;
    private volatile AtomicInteger samplingFactorHolder;
    private volatile ScheduledFuture<?> scheduledFuture;
    private SamplingRateWatcher samplingRateWatcher;

    @Override
    public void prepare() {
        this.samplingRateWatcher = new SamplingRateWatcher("agent.sample_n_per_3_secs", this);
    }

    @Override
    public void boot() {
        ServiceManager.INSTANCE.findService(ConfigurationDiscoveryService.class).registerAgentConfigChangeWatcher(this.samplingRateWatcher);
        this.handleSamplingRateChanged();
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public boolean trySampling(String operationName) {
        if (this.on) {
            int factor = this.samplingFactorHolder.get();
            if (factor < this.samplingRateWatcher.getSamplingRate()) {
                return this.samplingFactorHolder.compareAndSet(factor, factor + 1);
            }
            return false;
        }
        return true;
    }

    public void forceSampled() {
        if (this.on) {
            this.samplingFactorHolder.incrementAndGet();
        }
    }

    private void resetSamplingFactor() {
        this.samplingFactorHolder = new AtomicInteger(0);
    }

    void handleSamplingRateChanged() {
        if (this.samplingRateWatcher.getSamplingRate() > 0) {
            if (!this.on) {
                this.on = true;
                this.resetSamplingFactor();
                ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("SamplingService"));
                this.scheduledFuture = service.scheduleAtFixedRate(new RunnableWithExceptionProtection(this::resetSamplingFactor, t -> LOGGER.error("unexpected exception.", t)), 0L, 3L, TimeUnit.SECONDS);
                LOGGER.debug("Agent sampling mechanism started. Sample {} traces in 3 seconds.", this.samplingRateWatcher.getSamplingRate());
            }
        } else if (this.on) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            this.on = false;
        }
    }
}

