/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.util;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.skywalking.apm.util.StringUtil;

public final class MachineInfo {
    private static int PROCESS_NO = -1;
    private static String IP;
    private static String HOST_NAME;

    public static int getProcessNo() {
        if (PROCESS_NO == -1) {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            try {
                PROCESS_NO = Integer.parseInt(name.split("@")[0]);
            }
            catch (Throwable t) {
                PROCESS_NO = 0;
            }
        }
        return PROCESS_NO;
    }

    private static InetAddress getInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            HOST_NAME = "unknown host!";
            return null;
        }
    }

    public static String getHostIp() {
        if (StringUtil.isEmpty(IP)) {
            InetAddress netAddress = MachineInfo.getInetAddress();
            IP = null == netAddress ? "N/A" : netAddress.getHostAddress();
        }
        return IP;
    }

    public static String getHostName() {
        if (StringUtil.isEmpty(HOST_NAME)) {
            InetAddress netAddress = MachineInfo.getInetAddress();
            HOST_NAME = null == netAddress ? "N/A" : netAddress.getHostName();
        }
        return HOST_NAME;
    }

    public static String getHostDesc() {
        return MachineInfo.getHostName() + "/" + MachineInfo.getHostIp();
    }

    private MachineInfo() {
    }

    static {
        PROCESS_NO = MachineInfo.getProcessNo();
    }
}

