/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1;

import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;

public class StreamCallClientInterceptor
extends ForwardingClientCall.SimpleForwardingClientCall {
    private final String serviceName;
    private final String remotePeer;
    private final String operationPrefix;

    protected StreamCallClientInterceptor(ClientCall delegate, MethodDescriptor method, Channel channel) {
        super(delegate);
        this.serviceName = OperationNameFormatUtil.formatOperationName(method);
        this.remotePeer = channel.authority();
        this.operationPrefix = OperationNameFormatUtil.formatOperationName(method) + "/client";
    }

    public void start(ClientCall.Listener responseListener, Metadata headers) {
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)this.serviceName, (ContextCarrier)contextCarrier, (String)this.remotePeer);
        span.setComponent((Component)ComponentsDefine.GRPC);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        CarrierItem contextItem = contextCarrier.items();
        while (contextItem.hasNext()) {
            contextItem = contextItem.next();
            Metadata.Key headerKey = Metadata.Key.of((String)contextItem.getHeadKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            headers.put(headerKey, (Object)contextItem.getHeadValue());
        }
        this.delegate().start((ClientCall.Listener)new CallListener(responseListener, ContextManager.capture()), headers);
        ContextManager.stopSpan();
    }

    private class CallListener
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener {
        private final ContextSnapshot contextSnapshot;

        protected CallListener(ClientCall.Listener delegate, ContextSnapshot contextSnapshot) {
            super(delegate);
            this.contextSnapshot = contextSnapshot;
        }

        public void onReady() {
            this.delegate().onReady();
        }

        public void onHeaders(Metadata headers) {
            this.delegate().onHeaders(headers);
        }

        public void onMessage(Object message) {
            try {
                ContextManager.createLocalSpan((String)(StreamCallClientInterceptor.this.operationPrefix + "/ResponseObserver/onNext"));
                ContextManager.continued((ContextSnapshot)this.contextSnapshot);
                this.delegate().onMessage(message);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().errorOccurred().log(t);
            }
            finally {
                ContextManager.stopSpan();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Status status, Metadata trailers) {
            try {
                if (!status.isOk()) {
                    AbstractSpan abstractSpan = ContextManager.createLocalSpan((String)(StreamCallClientInterceptor.this.operationPrefix + "/ResponseObserver/onError"));
                    abstractSpan.errorOccurred().log(status.getCause());
                    Tags.STATUS_CODE.set(abstractSpan, status.getCode().name());
                } else {
                    AbstractSpan abstractSpan = ContextManager.createLocalSpan((String)(StreamCallClientInterceptor.this.operationPrefix + "/ResponseObserver/onComplete"));
                }
                this.delegate().onClose(status, trailers);
                ContextManager.continued((ContextSnapshot)this.contextSnapshot);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().errorOccurred().log(t);
            }
            finally {
                ContextManager.stopSpan();
            }
        }
    }
}

