/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1;

import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;
import org.apache.skywalking.apm.util.StringUtil;

public class CallServerInterceptor
implements ServerInterceptor {
    public ServerCall.Listener interceptCall(ServerCall call, Metadata headers, ServerCallHandler handler) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String key : headers.keys()) {
            if (key.endsWith("-bin")) continue;
            String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            headerMap.put(key, value);
        }
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            String contextValue = (String)headerMap.get((next = next.next()).getHeadKey());
            if (StringUtil.isEmpty((String)contextValue)) continue;
            next.setHeadValue(contextValue);
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)OperationNameFormatUtil.formatOperationName(call.getMethodDescriptor()), (ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.GRPC);
        return new ServerCallListener(handler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall(call){

            public void sendHeaders(Metadata responseHeaders) {
                this.delegate().sendHeaders(responseHeaders);
            }
        }, headers), call.getMethodDescriptor());
    }

    public class ServerCallListener
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener {
        protected ServerCallListener(ServerCall.Listener delegate, MethodDescriptor descriptor) {
            super(delegate);
        }

        public void onReady() {
            this.delegate().onReady();
        }

        public void onMessage(Object message) {
            try {
                ContextManager.createLocalSpan((String)"ResponseStreamObserver/OnNext");
                this.delegate().onMessage(message);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().errorOccurred().log(t);
            }
            finally {
                ContextManager.stopSpan();
            }
        }

        public void onComplete() {
            this.delegate().onComplete();
            ContextManager.stopSpan();
        }

        public void onCancel() {
            this.delegate().onCancel();
            ContextManager.stopSpan();
        }

        public void onHalfClose() {
            this.delegate().onHalfClose();
        }
    }
}

