/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1;

import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;

public class BlockingCallClientInterceptor
extends ForwardingClientCall.SimpleForwardingClientCall {
    private final MethodDescriptor methodDescriptor;
    private final Channel channel;

    public BlockingCallClientInterceptor(ClientCall delegate, MethodDescriptor method, Channel channel) {
        super(delegate);
        this.methodDescriptor = method;
        this.channel = channel;
    }

    public void start(ClientCall.Listener responseListener, Metadata headers) {
        ContextCarrier contextCarrier = new ContextCarrier();
        ContextManager.inject((ContextCarrier)contextCarrier);
        CarrierItem contextItem = contextCarrier.items();
        while (contextItem.hasNext()) {
            contextItem = contextItem.next();
            Metadata.Key headerKey = Metadata.Key.of((String)contextItem.getHeadKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            headers.put(headerKey, (Object)contextItem.getHeadValue());
        }
        this.delegate().start(responseListener, headers);
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

