/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1;

import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.BlockingCallClientInterceptor;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;

public class AsyncUnaryRequestCallCallInterceptor
implements StaticMethodsAroundInterceptor {
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        BlockingCallClientInterceptor originClientCall = (BlockingCallClientInterceptor)((Object)allArguments[0]);
        Channel channel = originClientCall.getChannel();
        MethodDescriptor methodDescriptor = originClientCall.getMethodDescriptor();
        AbstractSpan span = ContextManager.createExitSpan((String)OperationNameFormatUtil.formatOperationName(methodDescriptor), (String)channel.authority());
        span.setComponent((Component)ComponentsDefine.GRPC);
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

