/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1.client;

import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import javax.annotation.Nullable;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;

class TracingClientCall<REQUEST, RESPONSE>
extends ForwardingClientCall.SimpleForwardingClientCall<REQUEST, RESPONSE> {
    private final String serviceName;
    private final String remotePeer;
    private final String operationPrefix;
    private final MethodDescriptor<REQUEST, RESPONSE> methodDescriptor;
    private ContextSnapshot snapshot;

    TracingClientCall(ClientCall<REQUEST, RESPONSE> delegate, MethodDescriptor<REQUEST, RESPONSE> method, Channel channel) {
        super(delegate);
        this.methodDescriptor = method;
        this.serviceName = OperationNameFormatUtil.formatOperationName(method);
        this.remotePeer = channel.authority();
        this.operationPrefix = OperationNameFormatUtil.formatOperationName(method) + "/client";
    }

    public void start(ClientCall.Listener<RESPONSE> responseListener, Metadata headers) {
        AbstractSpan blockingSpan = (AbstractSpan)ContextManager.getRuntimeContext().get((Object)"SW_GRPC_BLOCKING_CALL_EXIT_SPAN");
        ContextCarrier contextCarrier = new ContextCarrier();
        if (blockingSpan == null) {
            AbstractSpan span = ContextManager.createExitSpan((String)this.serviceName, (String)this.remotePeer);
            span.setComponent((Component)ComponentsDefine.GRPC);
            span.setLayer(SpanLayer.RPC_FRAMEWORK);
        } else {
            ContextManager.getRuntimeContext().remove((Object)"SW_GRPC_BLOCKING_CALL_EXIT_SPAN");
        }
        ContextManager.inject((ContextCarrier)contextCarrier);
        CarrierItem contextItem = contextCarrier.items();
        while (contextItem.hasNext()) {
            contextItem = contextItem.next();
            Metadata.Key headerKey = Metadata.Key.of((String)contextItem.getHeadKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            headers.put(headerKey, (Object)contextItem.getHeadValue());
        }
        this.snapshot = ContextManager.capture();
        try {
            this.delegate().start((ClientCall.Listener)new TracingClientCallListener(responseListener, this.snapshot), headers);
        }
        catch (Throwable t) {
            ContextManager.activeSpan().errorOccurred().log(t);
            throw t;
        }
        finally {
            if (blockingSpan == null) {
                ContextManager.stopSpan();
            }
        }
    }

    public void sendMessage(REQUEST message) {
        if (this.methodDescriptor.getType().clientSendsOneMessage()) {
            super.sendMessage(message);
            return;
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onMessage"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.snapshot);
        try {
            super.sendMessage(message);
        }
        catch (Throwable t) {
            ContextManager.activeSpan().errorOccurred().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    public void halfClose() {
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onComplete"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.snapshot);
        try {
            super.halfClose();
        }
        catch (Throwable t) {
            ContextManager.activeSpan().errorOccurred().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onCancel"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.snapshot);
        if (cause != null) {
            span.log(cause);
        }
        try {
            super.cancel(message, cause);
        }
        catch (Throwable t) {
            ContextManager.activeSpan().errorOccurred().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    class TracingClientCallListener
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RESPONSE> {
        private final ContextSnapshot contextSnapshot;

        TracingClientCallListener(ClientCall.Listener<RESPONSE> delegate, ContextSnapshot contextSnapshot) {
            super(delegate);
            this.contextSnapshot = contextSnapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(RESPONSE message) {
            if (TracingClientCall.this.methodDescriptor.getType().serverSendsOneMessage()) {
                super.onMessage(message);
                return;
            }
            AbstractSpan span = ContextManager.createLocalSpan((String)(TracingClientCall.this.operationPrefix + "/Response/onMessage"));
            span.setComponent((Component)ComponentsDefine.GRPC);
            span.setLayer(SpanLayer.RPC_FRAMEWORK);
            ContextManager.continued((ContextSnapshot)this.contextSnapshot);
            try {
                this.delegate().onMessage(message);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().errorOccurred().log(t);
            }
            finally {
                ContextManager.stopSpan();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Status status, Metadata trailers) {
            AbstractSpan span = ContextManager.createLocalSpan((String)(TracingClientCall.this.operationPrefix + "/Response/onClose"));
            span.setComponent((Component)ComponentsDefine.GRPC);
            span.setLayer(SpanLayer.RPC_FRAMEWORK);
            ContextManager.continued((ContextSnapshot)this.contextSnapshot);
            if (!status.isOk()) {
                span.errorOccurred().log((Throwable)status.asRuntimeException());
                Tags.STATUS_CODE.set(span, status.getCode().name());
            }
            try {
                this.delegate().onClose(status, trailers);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().errorOccurred().log(t);
            }
            finally {
                ContextManager.stopSpan();
            }
        }
    }
}

