/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1.server;

import io.grpc.ForwardingServerCallListener;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;

public class TracingServerCallListener<REQUEST>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
    private final ContextSnapshot contextSnapshot;
    private final MethodDescriptor.MethodType methodType;
    private final String operationPrefix;

    protected TracingServerCallListener(ServerCall.Listener<REQUEST> delegate, MethodDescriptor<REQUEST, ?> descriptor, ContextSnapshot contextSnapshot) {
        super(delegate);
        this.contextSnapshot = contextSnapshot;
        this.methodType = descriptor.getType();
        this.operationPrefix = OperationNameFormatUtil.formatOperationName(descriptor) + "/server";
    }

    public void onMessage(REQUEST message) {
        if (!this.methodType.clientSendsOneMessage()) {
            AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onMessage"));
            span.setComponent((Component)ComponentsDefine.GRPC);
            span.setLayer(SpanLayer.RPC_FRAMEWORK);
            ContextManager.continued((ContextSnapshot)this.contextSnapshot);
            try {
                super.onMessage(message);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().errorOccurred().log(t);
                throw t;
            }
            finally {
                ContextManager.stopSpan();
            }
        } else {
            super.onMessage(message);
        }
    }

    public void onCancel() {
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onCancel"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        try {
            super.onCancel();
        }
        catch (Throwable t) {
            ContextManager.activeSpan().errorOccurred().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    public void onHalfClose() {
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onComplete"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        try {
            super.onHalfClose();
        }
        catch (Throwable t) {
            ContextManager.activeSpan().errorOccurred().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }
}

