/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1.server;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;

public class TracingServerCall<REQUEST, RESPONSE>
extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
    private final String operationPrefix;
    private final ContextSnapshot contextSnapshot;

    protected TracingServerCall(ServerCall<REQUEST, RESPONSE> delegate, ContextSnapshot contextSnapshot) {
        super(delegate);
        this.operationPrefix = OperationNameFormatUtil.formatOperationName(delegate.getMethodDescriptor()) + "/server";
        this.contextSnapshot = contextSnapshot;
    }

    public void sendMessage(RESPONSE message) {
        if (!this.getMethodDescriptor().getType().serverSendsOneMessage()) {
            AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Response/onMessage"));
            span.setComponent((Component)ComponentsDefine.GRPC);
            span.setLayer(SpanLayer.RPC_FRAMEWORK);
            ContextManager.continued((ContextSnapshot)this.contextSnapshot);
            try {
                super.sendMessage(message);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().log(t);
                throw t;
            }
            finally {
                ContextManager.stopSpan();
            }
        } else {
            super.sendMessage(message);
        }
    }

    public void close(Status status, Metadata trailers) {
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Response/onClose"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        switch (status.getCode()) {
            case OK: {
                break;
            }
            case UNKNOWN: 
            case INTERNAL: {
                if (status.getCause() == null) {
                    span.log((Throwable)status.asRuntimeException());
                    break;
                }
                span.log(status.getCause());
                break;
            }
            default: {
                if (status.getCause() == null) break;
                span.log(status.getCause());
            }
        }
        Tags.STATUS_CODE.set(span, status.getCode().name());
        try {
            super.close(status, trailers);
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }
}

