/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class PostgreSQLURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 5432;
    private static final String DB_TYPE = "PostgreSQL";

    public PostgreSQLURLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        int hostLabelEndIndex = this.url.indexOf("/", hostLabelStartIndex + 2);
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseStartTag = this.url.lastIndexOf("/");
        int databaseEndTag = this.url.indexOf("?", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        URLLocation location = this.fetchDatabaseHostsIndexRange();
        String hosts = this.url.substring(location.startIndex(), location.endIndex());
        String[] hostSegment = hosts.split(",");
        if (hostSegment.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                if (host.split(":").length == 1) {
                    sb.append(host + ":" + 5432 + ",");
                    continue;
                }
                sb.append(host + ",");
            }
            return new ConnectionInfo(ComponentsDefine.POSTGRESQL_DRIVER, DB_TYPE, sb.toString(), this.fetchDatabaseNameFromURL());
        }
        String[] hostAndPort = hostSegment[0].split(":");
        if (hostAndPort.length != 1) {
            return new ConnectionInfo(ComponentsDefine.POSTGRESQL_DRIVER, DB_TYPE, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL());
        }
        return new ConnectionInfo(ComponentsDefine.POSTGRESQL_DRIVER, DB_TYPE, hostAndPort[0], 5432, this.fetchDatabaseNameFromURL());
    }
}

