/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.H2URLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.MysqlURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.OracleURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.PostgreSQLURLParser;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class URLParser {
    private static final String MYSQL_JDBC_URL_PREFIX = "jdbc:mysql";
    private static final String ORACLE_JDBC_URL_PREFIX = "jdbc:oracle";
    private static final String H2_JDBC_URL_PREFIX = "jdbc:h2";
    private static final String POSTGRESQL_JDBC_URL_PREFIX = "jdbc:postgresql";

    public static ConnectionInfo parser(String url) {
        AbstractURLParser parser = null;
        if (url.startsWith(MYSQL_JDBC_URL_PREFIX)) {
            parser = new MysqlURLParser(url);
        } else if (url.startsWith(ORACLE_JDBC_URL_PREFIX)) {
            parser = new OracleURLParser(url);
        } else if (url.startsWith(H2_JDBC_URL_PREFIX)) {
            parser = new H2URLParser(url);
        } else if (url.startsWith(POSTGRESQL_JDBC_URL_PREFIX)) {
            parser = new PostgreSQLURLParser(url);
        }
        return parser.parse();
    }
}

