/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.trace;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class PreparedStatementTracing {
    public static <R> R execute(PreparedStatement realStatement, ConnectionInfo connectInfo, String method, String sql, Executable<R> exec) throws SQLException {
        AbstractSpan span = ContextManager.createExitSpan((String)(connectInfo.getDBType() + "/JDBI/PreparedStatement/" + method), (String)connectInfo.getDatabasePeer());
        try {
            Tags.DB_TYPE.set(span, "sql");
            Tags.DB_INSTANCE.set(span, connectInfo.getDatabaseName());
            Tags.DB_STATEMENT.set(span, sql);
            span.setComponent((Component)connectInfo.getComponent());
            SpanLayer.asDB((AbstractSpan)span);
            R r = exec.exe(realStatement, sql);
            return r;
        }
        catch (SQLException e) {
            span.errorOccurred();
            span.log((Throwable)e);
            throw e;
        }
        finally {
            ContextManager.stopSpan((AbstractSpan)span);
        }
    }

    public static interface Executable<R> {
        public R exe(PreparedStatement var1, String var2) throws SQLException;
    }
}

