/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc;

public class PreparedStatementParameterBuilder {
    private static final String EMPTY_LIST = "[]";
    private Object[] parameters;
    private Integer maxIndex;
    private int maxLength = 0;

    public PreparedStatementParameterBuilder setParameters(Object[] parameters) {
        this.parameters = parameters;
        return this;
    }

    public PreparedStatementParameterBuilder setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
        return this;
    }

    public PreparedStatementParameterBuilder setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public String build() {
        if (this.parameters == null) {
            return EMPTY_LIST;
        }
        String parameterString = this.getParameterString();
        return this.truncate(parameterString);
    }

    private String getParameterString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.getMaxIndex(); ++i) {
            Object parameter = this.parameters[i];
            if (!first) {
                stringBuilder.append(",");
            }
            stringBuilder.append(parameter);
            first = false;
        }
        return String.format("[%s]", stringBuilder.toString());
    }

    private int getMaxIndex() {
        int maxIdx = this.maxIndex != null ? this.maxIndex : this.parameters.length;
        return Math.min(maxIdx, this.parameters.length);
    }

    private String truncate(String parameterString) {
        if (this.maxLength > 0 && parameterString.length() > this.maxLength) {
            parameterString = parameterString.substring(0, this.maxLength) + "...";
        }
        return parameterString;
    }
}

