/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc;

import java.util.Set;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.InstanceMethodsInterceptPoint;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.skywalking.apm.plugin.jdbc.JDBCPluginConfig;
import org.apache.skywalking.apm.plugin.jdbc.define.Constants;

public class PSSetterDefinitionOfJDBCInstrumentation
implements InstanceMethodsInterceptPoint {
    private final boolean ignorable;

    public PSSetterDefinitionOfJDBCInstrumentation(boolean ignorable) {
        this.ignorable = ignorable;
    }

    public ElementMatcher<MethodDescription> getMethodsMatcher() {
        ElementMatcher.Junction matcher = ElementMatchers.none();
        if (JDBCPluginConfig.Plugin.MySQL.TRACE_SQL_PARAMETERS || JDBCPluginConfig.Plugin.POSTGRESQL.TRACE_SQL_PARAMETERS || JDBCPluginConfig.Plugin.MARIADB.TRACE_SQL_PARAMETERS) {
            Set<String> setters = this.ignorable ? Constants.PS_IGNORABLE_SETTERS : Constants.PS_SETTERS;
            for (String setter : setters) {
                matcher = matcher.or((ElementMatcher)ElementMatchers.named((String)setter));
            }
        }
        return matcher;
    }

    public String getMethodsInterceptor() {
        return this.ignorable ? "org.apache.skywalking.apm.plugin.jdbc.JDBCPreparedStatementIgnorableSetterInterceptor" : "org.apache.skywalking.apm.plugin.jdbc.JDBCPreparedStatementSetterInterceptor";
    }

    public boolean isOverrideArgs() {
        return false;
    }
}

