/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdk.threading;

import java.util.ArrayList;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;
import org.apache.skywalking.apm.agent.core.plugin.match.PrefixMatch;
import org.apache.skywalking.apm.agent.core.plugin.match.logical.LogicalMatchOperation;

public class ThreadingConfig {
    private static final ILog LOGGER = LogManager.getLogger(ThreadingConfig.class);

    public static IndirectMatch prefixesMatchesForJdkThreading() {
        String jointPrefixes = Config.Plugin.JdkThreading.THREADING_CLASS_PREFIXES;
        if (jointPrefixes == null || jointPrefixes.trim().isEmpty()) {
            return null;
        }
        String[] prefixes = jointPrefixes.split(",");
        ArrayList<PrefixMatch> prefixMatches = new ArrayList<PrefixMatch>();
        for (String prefix : prefixes) {
            if (prefix.startsWith("java.") || prefix.startsWith("javax.")) {
                LOGGER.warn("prefix {} is ignored", new Object[]{prefix});
                continue;
            }
            prefixMatches.add(PrefixMatch.nameStartsWith((String[])new String[]{prefix}));
        }
        if (prefixMatches.size() == 0) {
            return null;
        }
        return LogicalMatchOperation.or((IndirectMatch[])((IndirectMatch[])prefixMatches.toArray(new PrefixMatch[0])));
    }
}

