/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.kafka;

import java.lang.reflect.Method;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class CallbackInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ContextSnapshot contextSnapshot = (ContextSnapshot)objInst.getSkyWalkingDynamicField();
        if (null != contextSnapshot) {
            RecordMetadata metadata = (RecordMetadata)allArguments[0];
            AbstractSpan activeSpan = ContextManager.createLocalSpan((String)"Kafka/Producer/Callback");
            activeSpan.setComponent((Component)ComponentsDefine.KAFKA_PRODUCER);
            Tags.MQ_TOPIC.set(activeSpan, metadata.topic());
            ContextManager.continued((ContextSnapshot)contextSnapshot);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextSnapshot contextSnapshot = (ContextSnapshot)objInst.getSkyWalkingDynamicField();
        if (null != contextSnapshot) {
            Exception exceptions = (Exception)allArguments[1];
            if (exceptions != null) {
                ContextManager.activeSpan().errorOccurred().log((Throwable)exceptions);
            }
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

