/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.mongodb.v2;

import com.mongodb.AggregationOutput;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class MongoDBCollectionMethodInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    private static final String DB_TYPE = "MongoDB";
    private static final String MONGO_DB_OP_PREFIX = "MongoDB/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String remotePeer = (String)objInst.getSkyWalkingDynamicField();
        String operation = method.getName();
        AbstractSpan span = ContextManager.createExitSpan((String)(MONGO_DB_OP_PREFIX + operation), (ContextCarrier)new ContextCarrier(), (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.MONGO_DRIVER);
        Tags.DB_TYPE.set(span, DB_TYPE);
        SpanLayer.asDB((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        CommandResult cresult = null;
        if (ret instanceof WriteResult) {
            WriteResult wresult = (WriteResult)ret;
            cresult = wresult.getCachedLastError();
        } else if (ret instanceof AggregationOutput) {
            AggregationOutput aresult = (AggregationOutput)ret;
            cresult = aresult.getCommandResult();
        }
        if (null != cresult && !cresult.ok()) {
            activeSpan.log((Throwable)cresult.getException());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.errorOccurred();
        activeSpan.log(t);
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        List servers = null;
        DB db = (DB)allArguments[0];
        servers = db.getMongo().getAllAddress();
        StringBuilder peers = new StringBuilder();
        for (ServerAddress address : servers) {
            peers.append(address.getHost() + ":" + address.getPort() + ";");
        }
        objInst.setSkyWalkingDynamicField((Object)peers.subSequence(0, peers.length() - 1).toString());
    }
}

