/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.mongodb.v3.support;

import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.mongodb.v3.support.MongoOperationHelper;

public class MongoSpanHelper {
    private MongoSpanHelper() {
    }

    public static void createExitSpan(String executeMethod, String remotePeer, Object operation) {
        AbstractSpan span = ContextManager.createExitSpan((String)("MongoDB/" + executeMethod), (ContextCarrier)new ContextCarrier(), (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.MONGO_DRIVER);
        Tags.DB_TYPE.set(span, "MongoDB");
        SpanLayer.asDB((AbstractSpan)span);
        if (Config.Plugin.MongoDB.TRACE_PARAM) {
            Tags.DB_STATEMENT.set(span, executeMethod + " " + MongoOperationHelper.getTraceParam(operation));
        }
    }
}

