/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.mongodb.v3.interceptor.v37;

import com.mongodb.connection.Cluster;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.mongodb.v3.support.MongoRemotePeerHelper;

public class MongoDBClientDelegateInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    private static final ILog logger = LogManager.getLogger(MongoDBClientDelegateInterceptor.class);

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        Cluster cluster = (Cluster)allArguments[0];
        String remotePeer = MongoRemotePeerHelper.getRemotePeer(cluster);
        objInst.setSkyWalkingDynamicField((Object)remotePeer);
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        if (ret instanceof EnhancedInstance) {
            EnhancedInstance retInstance = (EnhancedInstance)ret;
            String remotePeer = (String)objInst.getSkyWalkingDynamicField();
            if (logger.isDebugEnable()) {
                logger.debug("Mark OperationExecutor remotePeer: {}", new Object[]{remotePeer});
            }
            retInstance.setSkyWalkingDynamicField((Object)remotePeer);
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

