// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: language-agent/Tracing.proto

package org.apache.skywalking.apm.network.language.agent.v3;

/**
 * <pre>
 * Span represents a execution unit in the system, with duration and many other attributes.
 * Span could be a method, a RPC, MQ message produce or consume.
 * In the practice, the span should be added when it is really necessary, to avoid payload overhead.
 * We recommend to creating spans in across process(client/server of RPC/MQ) and across thread cases only.
 * </pre>
 *
 * Protobuf type {@code skywalking.v3.SpanObject}
 */
public final class SpanObject extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:skywalking.v3.SpanObject)
    SpanObjectOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SpanObject.newBuilder() to construct.
  private SpanObject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SpanObject() {
    refs_ = java.util.Collections.emptyList();
    operationName_ = "";
    peer_ = "";
    spanType_ = 0;
    spanLayer_ = 0;
    tags_ = java.util.Collections.emptyList();
    logs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new SpanObject();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private SpanObject(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {

            spanId_ = input.readInt32();
            break;
          }
          case 16: {

            parentSpanId_ = input.readInt32();
            break;
          }
          case 24: {

            startTime_ = input.readInt64();
            break;
          }
          case 32: {

            endTime_ = input.readInt64();
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              refs_ = new java.util.ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SegmentReference>();
              mutable_bitField0_ |= 0x00000001;
            }
            refs_.add(
                input.readMessage(org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.parser(), extensionRegistry));
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            operationName_ = s;
            break;
          }
          case 58: {
            java.lang.String s = input.readStringRequireUtf8();

            peer_ = s;
            break;
          }
          case 64: {
            int rawValue = input.readEnum();

            spanType_ = rawValue;
            break;
          }
          case 72: {
            int rawValue = input.readEnum();

            spanLayer_ = rawValue;
            break;
          }
          case 80: {

            componentId_ = input.readInt32();
            break;
          }
          case 88: {

            isError_ = input.readBool();
            break;
          }
          case 98: {
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              tags_ = new java.util.ArrayList<org.apache.skywalking.apm.network.common.v3.KeyStringValuePair>();
              mutable_bitField0_ |= 0x00000002;
            }
            tags_.add(
                input.readMessage(org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.parser(), extensionRegistry));
            break;
          }
          case 106: {
            if (!((mutable_bitField0_ & 0x00000004) != 0)) {
              logs_ = new java.util.ArrayList<org.apache.skywalking.apm.network.language.agent.v3.Log>();
              mutable_bitField0_ |= 0x00000004;
            }
            logs_.add(
                input.readMessage(org.apache.skywalking.apm.network.language.agent.v3.Log.parser(), extensionRegistry));
            break;
          }
          case 112: {

            skipAnalysis_ = input.readBool();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        refs_ = java.util.Collections.unmodifiableList(refs_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        tags_ = java.util.Collections.unmodifiableList(tags_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        logs_ = java.util.Collections.unmodifiableList(logs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return org.apache.skywalking.apm.network.language.agent.v3.Tracing.internal_static_skywalking_v3_SpanObject_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.skywalking.apm.network.language.agent.v3.Tracing.internal_static_skywalking_v3_SpanObject_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.skywalking.apm.network.language.agent.v3.SpanObject.class, org.apache.skywalking.apm.network.language.agent.v3.SpanObject.Builder.class);
  }

  public static final int SPANID_FIELD_NUMBER = 1;
  private int spanId_;
  /**
   * <pre>
   * The number id of the span. Should be unique in the whole segment.
   * Starting at 0.
   * </pre>
   *
   * <code>int32 spanId = 1;</code>
   * @return The spanId.
   */
  @java.lang.Override
  public int getSpanId() {
    return spanId_;
  }

  public static final int PARENTSPANID_FIELD_NUMBER = 2;
  private int parentSpanId_;
  /**
   * <pre>
   * The number id of the parent span in the whole segment.
   * -1 represents no parent span.
   * Also, be known as the root/first span of the segment.
   * </pre>
   *
   * <code>int32 parentSpanId = 2;</code>
   * @return The parentSpanId.
   */
  @java.lang.Override
  public int getParentSpanId() {
    return parentSpanId_;
  }

  public static final int STARTTIME_FIELD_NUMBER = 3;
  private long startTime_;
  /**
   * <pre>
   * Start timestamp in milliseconds of this span,
   * measured between the current time and midnight, January 1, 1970 UTC.
   * </pre>
   *
   * <code>int64 startTime = 3;</code>
   * @return The startTime.
   */
  @java.lang.Override
  public long getStartTime() {
    return startTime_;
  }

  public static final int ENDTIME_FIELD_NUMBER = 4;
  private long endTime_;
  /**
   * <pre>
   * End timestamp in milliseconds of this span,
   * measured between the current time and midnight, January 1, 1970 UTC.
   * </pre>
   *
   * <code>int64 endTime = 4;</code>
   * @return The endTime.
   */
  @java.lang.Override
  public long getEndTime() {
    return endTime_;
  }

  public static final int REFS_FIELD_NUMBER = 5;
  private java.util.List<org.apache.skywalking.apm.network.language.agent.v3.SegmentReference> refs_;
  /**
   * <pre>
   * &lt;Optional&gt;
   * In the across thread and across process, these references targeting the parent segments.
   * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
   * </pre>
   *
   * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<org.apache.skywalking.apm.network.language.agent.v3.SegmentReference> getRefsList() {
    return refs_;
  }
  /**
   * <pre>
   * &lt;Optional&gt;
   * In the across thread and across process, these references targeting the parent segments.
   * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
   * </pre>
   *
   * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.apache.skywalking.apm.network.language.agent.v3.SegmentReferenceOrBuilder> 
      getRefsOrBuilderList() {
    return refs_;
  }
  /**
   * <pre>
   * &lt;Optional&gt;
   * In the across thread and across process, these references targeting the parent segments.
   * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
   * </pre>
   *
   * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
   */
  @java.lang.Override
  public int getRefsCount() {
    return refs_.size();
  }
  /**
   * <pre>
   * &lt;Optional&gt;
   * In the across thread and across process, these references targeting the parent segments.
   * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
   * </pre>
   *
   * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
   */
  @java.lang.Override
  public org.apache.skywalking.apm.network.language.agent.v3.SegmentReference getRefs(int index) {
    return refs_.get(index);
  }
  /**
   * <pre>
   * &lt;Optional&gt;
   * In the across thread and across process, these references targeting the parent segments.
   * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
   * </pre>
   *
   * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
   */
  @java.lang.Override
  public org.apache.skywalking.apm.network.language.agent.v3.SegmentReferenceOrBuilder getRefsOrBuilder(
      int index) {
    return refs_.get(index);
  }

  public static final int OPERATIONNAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object operationName_;
  /**
   * <pre>
   * A logic name represents this span.
   * We don't recommend to include the parameter, such as HTTP request parameters, as a part of the operation, especially this is the name of the entry span.
   * All statistic for the endpoints are aggregated base on this name. Those parameters should be added in the tags if necessary.
   * If in some cases, it have to be a part of the operation name,
   * users should use the Group Parameterized Endpoints capability at the backend to get the meaningful metrics.
   * Read https://github.com/apache/skywalking/blob/master/docs/en/setup/backend/endpoint-grouping-rules.md
   * </pre>
   *
   * <code>string operationName = 6;</code>
   * @return The operationName.
   */
  @java.lang.Override
  public java.lang.String getOperationName() {
    java.lang.Object ref = operationName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * A logic name represents this span.
   * We don't recommend to include the parameter, such as HTTP request parameters, as a part of the operation, especially this is the name of the entry span.
   * All statistic for the endpoints are aggregated base on this name. Those parameters should be added in the tags if necessary.
   * If in some cases, it have to be a part of the operation name,
   * users should use the Group Parameterized Endpoints capability at the backend to get the meaningful metrics.
   * Read https://github.com/apache/skywalking/blob/master/docs/en/setup/backend/endpoint-grouping-rules.md
   * </pre>
   *
   * <code>string operationName = 6;</code>
   * @return The bytes for operationName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getOperationNameBytes() {
    java.lang.Object ref = operationName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      operationName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_FIELD_NUMBER = 7;
  private volatile java.lang.Object peer_;
  /**
   * <pre>
   * Remote address of the peer in RPC/MQ case.
   * This is required when spanType = Exit, as it is a part of the SkyWalking STAM(Streaming Topology Analysis Method).
   * For more details, read https://wu-sheng.github.io/STAM/
   * </pre>
   *
   * <code>string peer = 7;</code>
   * @return The peer.
   */
  @java.lang.Override
  public java.lang.String getPeer() {
    java.lang.Object ref = peer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peer_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Remote address of the peer in RPC/MQ case.
   * This is required when spanType = Exit, as it is a part of the SkyWalking STAM(Streaming Topology Analysis Method).
   * For more details, read https://wu-sheng.github.io/STAM/
   * </pre>
   *
   * <code>string peer = 7;</code>
   * @return The bytes for peer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPeerBytes() {
    java.lang.Object ref = peer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      peer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPANTYPE_FIELD_NUMBER = 8;
  private int spanType_;
  /**
   * <pre>
   * Span type represents the role in the RPC context.
   * </pre>
   *
   * <code>.skywalking.v3.SpanType spanType = 8;</code>
   * @return The enum numeric value on the wire for spanType.
   */
  @java.lang.Override public int getSpanTypeValue() {
    return spanType_;
  }
  /**
   * <pre>
   * Span type represents the role in the RPC context.
   * </pre>
   *
   * <code>.skywalking.v3.SpanType spanType = 8;</code>
   * @return The spanType.
   */
  @java.lang.Override public org.apache.skywalking.apm.network.language.agent.v3.SpanType getSpanType() {
    @SuppressWarnings("deprecation")
    org.apache.skywalking.apm.network.language.agent.v3.SpanType result = org.apache.skywalking.apm.network.language.agent.v3.SpanType.valueOf(spanType_);
    return result == null ? org.apache.skywalking.apm.network.language.agent.v3.SpanType.UNRECOGNIZED : result;
  }

  public static final int SPANLAYER_FIELD_NUMBER = 9;
  private int spanLayer_;
  /**
   * <pre>
   * Span layer represent the component tech stack, related to the network tech.
   * </pre>
   *
   * <code>.skywalking.v3.SpanLayer spanLayer = 9;</code>
   * @return The enum numeric value on the wire for spanLayer.
   */
  @java.lang.Override public int getSpanLayerValue() {
    return spanLayer_;
  }
  /**
   * <pre>
   * Span layer represent the component tech stack, related to the network tech.
   * </pre>
   *
   * <code>.skywalking.v3.SpanLayer spanLayer = 9;</code>
   * @return The spanLayer.
   */
  @java.lang.Override public org.apache.skywalking.apm.network.language.agent.v3.SpanLayer getSpanLayer() {
    @SuppressWarnings("deprecation")
    org.apache.skywalking.apm.network.language.agent.v3.SpanLayer result = org.apache.skywalking.apm.network.language.agent.v3.SpanLayer.valueOf(spanLayer_);
    return result == null ? org.apache.skywalking.apm.network.language.agent.v3.SpanLayer.UNRECOGNIZED : result;
  }

  public static final int COMPONENTID_FIELD_NUMBER = 10;
  private int componentId_;
  /**
   * <pre>
   * Component id is a predefinited number id in the SkyWalking.
   * It represents the framework, tech stack used by this tracked span, such as Spring.
   * All IDs are defined in the https://github.com/apache/skywalking/blob/master/oap-server/server-bootstrap/src/main/resources/component-libraries.yml
   * Send a pull request if you want to add languages, components or mapping defintions,
   * all public components could be accepted.
   * Follow this doc for more details, https://github.com/apache/skywalking/blob/master/docs/en/guides/Component-library-settings.md
   * </pre>
   *
   * <code>int32 componentId = 10;</code>
   * @return The componentId.
   */
  @java.lang.Override
  public int getComponentId() {
    return componentId_;
  }

  public static final int ISERROR_FIELD_NUMBER = 11;
  private boolean isError_;
  /**
   * <pre>
   * The status of the span. False means the tracked execution ends in the unexpected status.
   * This affects the successful rate statistic in the backend.
   * Exception or error code happened in the tracked process doesn't mean isError == true, the implementations of agent plugin and tracing SDK make the final decision.
   * </pre>
   *
   * <code>bool isError = 11;</code>
   * @return The isError.
   */
  @java.lang.Override
  public boolean getIsError() {
    return isError_;
  }

  public static final int TAGS_FIELD_NUMBER = 12;
  private java.util.List<org.apache.skywalking.apm.network.common.v3.KeyStringValuePair> tags_;
  /**
   * <pre>
   * String key, String value pair.
   * Tags provides more informance, includes parameters.
   * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
   * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
   * </pre>
   *
   * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
   */
  @java.lang.Override
  public java.util.List<org.apache.skywalking.apm.network.common.v3.KeyStringValuePair> getTagsList() {
    return tags_;
  }
  /**
   * <pre>
   * String key, String value pair.
   * Tags provides more informance, includes parameters.
   * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
   * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
   * </pre>
   *
   * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.apache.skywalking.apm.network.common.v3.KeyStringValuePairOrBuilder> 
      getTagsOrBuilderList() {
    return tags_;
  }
  /**
   * <pre>
   * String key, String value pair.
   * Tags provides more informance, includes parameters.
   * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
   * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
   * </pre>
   *
   * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
   */
  @java.lang.Override
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   * <pre>
   * String key, String value pair.
   * Tags provides more informance, includes parameters.
   * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
   * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
   * </pre>
   *
   * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
   */
  @java.lang.Override
  public org.apache.skywalking.apm.network.common.v3.KeyStringValuePair getTags(int index) {
    return tags_.get(index);
  }
  /**
   * <pre>
   * String key, String value pair.
   * Tags provides more informance, includes parameters.
   * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
   * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
   * </pre>
   *
   * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
   */
  @java.lang.Override
  public org.apache.skywalking.apm.network.common.v3.KeyStringValuePairOrBuilder getTagsOrBuilder(
      int index) {
    return tags_.get(index);
  }

  public static final int LOGS_FIELD_NUMBER = 13;
  private java.util.List<org.apache.skywalking.apm.network.language.agent.v3.Log> logs_;
  /**
   * <pre>
   * String key, String value pair with an accurate timestamp.
   * Logging some events happening in the context of the span duration.
   * </pre>
   *
   * <code>repeated .skywalking.v3.Log logs = 13;</code>
   */
  @java.lang.Override
  public java.util.List<org.apache.skywalking.apm.network.language.agent.v3.Log> getLogsList() {
    return logs_;
  }
  /**
   * <pre>
   * String key, String value pair with an accurate timestamp.
   * Logging some events happening in the context of the span duration.
   * </pre>
   *
   * <code>repeated .skywalking.v3.Log logs = 13;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.apache.skywalking.apm.network.language.agent.v3.LogOrBuilder> 
      getLogsOrBuilderList() {
    return logs_;
  }
  /**
   * <pre>
   * String key, String value pair with an accurate timestamp.
   * Logging some events happening in the context of the span duration.
   * </pre>
   *
   * <code>repeated .skywalking.v3.Log logs = 13;</code>
   */
  @java.lang.Override
  public int getLogsCount() {
    return logs_.size();
  }
  /**
   * <pre>
   * String key, String value pair with an accurate timestamp.
   * Logging some events happening in the context of the span duration.
   * </pre>
   *
   * <code>repeated .skywalking.v3.Log logs = 13;</code>
   */
  @java.lang.Override
  public org.apache.skywalking.apm.network.language.agent.v3.Log getLogs(int index) {
    return logs_.get(index);
  }
  /**
   * <pre>
   * String key, String value pair with an accurate timestamp.
   * Logging some events happening in the context of the span duration.
   * </pre>
   *
   * <code>repeated .skywalking.v3.Log logs = 13;</code>
   */
  @java.lang.Override
  public org.apache.skywalking.apm.network.language.agent.v3.LogOrBuilder getLogsOrBuilder(
      int index) {
    return logs_.get(index);
  }

  public static final int SKIPANALYSIS_FIELD_NUMBER = 14;
  private boolean skipAnalysis_;
  /**
   * <pre>
   * Force the backend don't do analysis, if the value is TRUE.
   * The backend has its own configurations to follow or override this.
   * Use this mostly because the agent/SDK could know more context of the service role.
   * </pre>
   *
   * <code>bool skipAnalysis = 14;</code>
   * @return The skipAnalysis.
   */
  @java.lang.Override
  public boolean getSkipAnalysis() {
    return skipAnalysis_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (spanId_ != 0) {
      output.writeInt32(1, spanId_);
    }
    if (parentSpanId_ != 0) {
      output.writeInt32(2, parentSpanId_);
    }
    if (startTime_ != 0L) {
      output.writeInt64(3, startTime_);
    }
    if (endTime_ != 0L) {
      output.writeInt64(4, endTime_);
    }
    for (int i = 0; i < refs_.size(); i++) {
      output.writeMessage(5, refs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, operationName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, peer_);
    }
    if (spanType_ != org.apache.skywalking.apm.network.language.agent.v3.SpanType.Entry.getNumber()) {
      output.writeEnum(8, spanType_);
    }
    if (spanLayer_ != org.apache.skywalking.apm.network.language.agent.v3.SpanLayer.Unknown.getNumber()) {
      output.writeEnum(9, spanLayer_);
    }
    if (componentId_ != 0) {
      output.writeInt32(10, componentId_);
    }
    if (isError_ != false) {
      output.writeBool(11, isError_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      output.writeMessage(12, tags_.get(i));
    }
    for (int i = 0; i < logs_.size(); i++) {
      output.writeMessage(13, logs_.get(i));
    }
    if (skipAnalysis_ != false) {
      output.writeBool(14, skipAnalysis_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (spanId_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(1, spanId_);
    }
    if (parentSpanId_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(2, parentSpanId_);
    }
    if (startTime_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(3, startTime_);
    }
    if (endTime_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(4, endTime_);
    }
    for (int i = 0; i < refs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, refs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, operationName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, peer_);
    }
    if (spanType_ != org.apache.skywalking.apm.network.language.agent.v3.SpanType.Entry.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(8, spanType_);
    }
    if (spanLayer_ != org.apache.skywalking.apm.network.language.agent.v3.SpanLayer.Unknown.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(9, spanLayer_);
    }
    if (componentId_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(10, componentId_);
    }
    if (isError_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(11, isError_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(12, tags_.get(i));
    }
    for (int i = 0; i < logs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(13, logs_.get(i));
    }
    if (skipAnalysis_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(14, skipAnalysis_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof org.apache.skywalking.apm.network.language.agent.v3.SpanObject)) {
      return super.equals(obj);
    }
    org.apache.skywalking.apm.network.language.agent.v3.SpanObject other = (org.apache.skywalking.apm.network.language.agent.v3.SpanObject) obj;

    if (getSpanId()
        != other.getSpanId()) return false;
    if (getParentSpanId()
        != other.getParentSpanId()) return false;
    if (getStartTime()
        != other.getStartTime()) return false;
    if (getEndTime()
        != other.getEndTime()) return false;
    if (!getRefsList()
        .equals(other.getRefsList())) return false;
    if (!getOperationName()
        .equals(other.getOperationName())) return false;
    if (!getPeer()
        .equals(other.getPeer())) return false;
    if (spanType_ != other.spanType_) return false;
    if (spanLayer_ != other.spanLayer_) return false;
    if (getComponentId()
        != other.getComponentId()) return false;
    if (getIsError()
        != other.getIsError()) return false;
    if (!getTagsList()
        .equals(other.getTagsList())) return false;
    if (!getLogsList()
        .equals(other.getLogsList())) return false;
    if (getSkipAnalysis()
        != other.getSkipAnalysis()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SPANID_FIELD_NUMBER;
    hash = (53 * hash) + getSpanId();
    hash = (37 * hash) + PARENTSPANID_FIELD_NUMBER;
    hash = (53 * hash) + getParentSpanId();
    hash = (37 * hash) + STARTTIME_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getStartTime());
    hash = (37 * hash) + ENDTIME_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getEndTime());
    if (getRefsCount() > 0) {
      hash = (37 * hash) + REFS_FIELD_NUMBER;
      hash = (53 * hash) + getRefsList().hashCode();
    }
    hash = (37 * hash) + OPERATIONNAME_FIELD_NUMBER;
    hash = (53 * hash) + getOperationName().hashCode();
    hash = (37 * hash) + PEER_FIELD_NUMBER;
    hash = (53 * hash) + getPeer().hashCode();
    hash = (37 * hash) + SPANTYPE_FIELD_NUMBER;
    hash = (53 * hash) + spanType_;
    hash = (37 * hash) + SPANLAYER_FIELD_NUMBER;
    hash = (53 * hash) + spanLayer_;
    hash = (37 * hash) + COMPONENTID_FIELD_NUMBER;
    hash = (53 * hash) + getComponentId();
    hash = (37 * hash) + ISERROR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getIsError());
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (getLogsCount() > 0) {
      hash = (37 * hash) + LOGS_FIELD_NUMBER;
      hash = (53 * hash) + getLogsList().hashCode();
    }
    hash = (37 * hash) + SKIPANALYSIS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getSkipAnalysis());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(org.apache.skywalking.apm.network.language.agent.v3.SpanObject prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Span represents a execution unit in the system, with duration and many other attributes.
   * Span could be a method, a RPC, MQ message produce or consume.
   * In the practice, the span should be added when it is really necessary, to avoid payload overhead.
   * We recommend to creating spans in across process(client/server of RPC/MQ) and across thread cases only.
   * </pre>
   *
   * Protobuf type {@code skywalking.v3.SpanObject}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:skywalking.v3.SpanObject)
      org.apache.skywalking.apm.network.language.agent.v3.SpanObjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.skywalking.apm.network.language.agent.v3.Tracing.internal_static_skywalking_v3_SpanObject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.skywalking.apm.network.language.agent.v3.Tracing.internal_static_skywalking_v3_SpanObject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.skywalking.apm.network.language.agent.v3.SpanObject.class, org.apache.skywalking.apm.network.language.agent.v3.SpanObject.Builder.class);
    }

    // Construct using org.apache.skywalking.apm.network.language.agent.v3.SpanObject.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getRefsFieldBuilder();
        getTagsFieldBuilder();
        getLogsFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      spanId_ = 0;

      parentSpanId_ = 0;

      startTime_ = 0L;

      endTime_ = 0L;

      if (refsBuilder_ == null) {
        refs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        refsBuilder_.clear();
      }
      operationName_ = "";

      peer_ = "";

      spanType_ = 0;

      spanLayer_ = 0;

      componentId_ = 0;

      isError_ = false;

      if (tagsBuilder_ == null) {
        tags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        tagsBuilder_.clear();
      }
      if (logsBuilder_ == null) {
        logs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        logsBuilder_.clear();
      }
      skipAnalysis_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return org.apache.skywalking.apm.network.language.agent.v3.Tracing.internal_static_skywalking_v3_SpanObject_descriptor;
    }

    @java.lang.Override
    public org.apache.skywalking.apm.network.language.agent.v3.SpanObject getDefaultInstanceForType() {
      return org.apache.skywalking.apm.network.language.agent.v3.SpanObject.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.skywalking.apm.network.language.agent.v3.SpanObject build() {
      org.apache.skywalking.apm.network.language.agent.v3.SpanObject result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.skywalking.apm.network.language.agent.v3.SpanObject buildPartial() {
      org.apache.skywalking.apm.network.language.agent.v3.SpanObject result = new org.apache.skywalking.apm.network.language.agent.v3.SpanObject(this);
      int from_bitField0_ = bitField0_;
      result.spanId_ = spanId_;
      result.parentSpanId_ = parentSpanId_;
      result.startTime_ = startTime_;
      result.endTime_ = endTime_;
      if (refsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          refs_ = java.util.Collections.unmodifiableList(refs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.refs_ = refs_;
      } else {
        result.refs_ = refsBuilder_.build();
      }
      result.operationName_ = operationName_;
      result.peer_ = peer_;
      result.spanType_ = spanType_;
      result.spanLayer_ = spanLayer_;
      result.componentId_ = componentId_;
      result.isError_ = isError_;
      if (tagsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          tags_ = java.util.Collections.unmodifiableList(tags_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.tags_ = tags_;
      } else {
        result.tags_ = tagsBuilder_.build();
      }
      if (logsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          logs_ = java.util.Collections.unmodifiableList(logs_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.logs_ = logs_;
      } else {
        result.logs_ = logsBuilder_.build();
      }
      result.skipAnalysis_ = skipAnalysis_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof org.apache.skywalking.apm.network.language.agent.v3.SpanObject) {
        return mergeFrom((org.apache.skywalking.apm.network.language.agent.v3.SpanObject)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.skywalking.apm.network.language.agent.v3.SpanObject other) {
      if (other == org.apache.skywalking.apm.network.language.agent.v3.SpanObject.getDefaultInstance()) return this;
      if (other.getSpanId() != 0) {
        setSpanId(other.getSpanId());
      }
      if (other.getParentSpanId() != 0) {
        setParentSpanId(other.getParentSpanId());
      }
      if (other.getStartTime() != 0L) {
        setStartTime(other.getStartTime());
      }
      if (other.getEndTime() != 0L) {
        setEndTime(other.getEndTime());
      }
      if (refsBuilder_ == null) {
        if (!other.refs_.isEmpty()) {
          if (refs_.isEmpty()) {
            refs_ = other.refs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRefsIsMutable();
            refs_.addAll(other.refs_);
          }
          onChanged();
        }
      } else {
        if (!other.refs_.isEmpty()) {
          if (refsBuilder_.isEmpty()) {
            refsBuilder_.dispose();
            refsBuilder_ = null;
            refs_ = other.refs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            refsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRefsFieldBuilder() : null;
          } else {
            refsBuilder_.addAllMessages(other.refs_);
          }
        }
      }
      if (!other.getOperationName().isEmpty()) {
        operationName_ = other.operationName_;
        onChanged();
      }
      if (!other.getPeer().isEmpty()) {
        peer_ = other.peer_;
        onChanged();
      }
      if (other.spanType_ != 0) {
        setSpanTypeValue(other.getSpanTypeValue());
      }
      if (other.spanLayer_ != 0) {
        setSpanLayerValue(other.getSpanLayerValue());
      }
      if (other.getComponentId() != 0) {
        setComponentId(other.getComponentId());
      }
      if (other.getIsError() != false) {
        setIsError(other.getIsError());
      }
      if (tagsBuilder_ == null) {
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
      } else {
        if (!other.tags_.isEmpty()) {
          if (tagsBuilder_.isEmpty()) {
            tagsBuilder_.dispose();
            tagsBuilder_ = null;
            tags_ = other.tags_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tagsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getTagsFieldBuilder() : null;
          } else {
            tagsBuilder_.addAllMessages(other.tags_);
          }
        }
      }
      if (logsBuilder_ == null) {
        if (!other.logs_.isEmpty()) {
          if (logs_.isEmpty()) {
            logs_ = other.logs_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureLogsIsMutable();
            logs_.addAll(other.logs_);
          }
          onChanged();
        }
      } else {
        if (!other.logs_.isEmpty()) {
          if (logsBuilder_.isEmpty()) {
            logsBuilder_.dispose();
            logsBuilder_ = null;
            logs_ = other.logs_;
            bitField0_ = (bitField0_ & ~0x00000004);
            logsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getLogsFieldBuilder() : null;
          } else {
            logsBuilder_.addAllMessages(other.logs_);
          }
        }
      }
      if (other.getSkipAnalysis() != false) {
        setSkipAnalysis(other.getSkipAnalysis());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.skywalking.apm.network.language.agent.v3.SpanObject parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.skywalking.apm.network.language.agent.v3.SpanObject) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private int spanId_ ;
    /**
     * <pre>
     * The number id of the span. Should be unique in the whole segment.
     * Starting at 0.
     * </pre>
     *
     * <code>int32 spanId = 1;</code>
     * @return The spanId.
     */
    @java.lang.Override
    public int getSpanId() {
      return spanId_;
    }
    /**
     * <pre>
     * The number id of the span. Should be unique in the whole segment.
     * Starting at 0.
     * </pre>
     *
     * <code>int32 spanId = 1;</code>
     * @param value The spanId to set.
     * @return This builder for chaining.
     */
    public Builder setSpanId(int value) {
      
      spanId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number id of the span. Should be unique in the whole segment.
     * Starting at 0.
     * </pre>
     *
     * <code>int32 spanId = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearSpanId() {
      
      spanId_ = 0;
      onChanged();
      return this;
    }

    private int parentSpanId_ ;
    /**
     * <pre>
     * The number id of the parent span in the whole segment.
     * -1 represents no parent span.
     * Also, be known as the root/first span of the segment.
     * </pre>
     *
     * <code>int32 parentSpanId = 2;</code>
     * @return The parentSpanId.
     */
    @java.lang.Override
    public int getParentSpanId() {
      return parentSpanId_;
    }
    /**
     * <pre>
     * The number id of the parent span in the whole segment.
     * -1 represents no parent span.
     * Also, be known as the root/first span of the segment.
     * </pre>
     *
     * <code>int32 parentSpanId = 2;</code>
     * @param value The parentSpanId to set.
     * @return This builder for chaining.
     */
    public Builder setParentSpanId(int value) {
      
      parentSpanId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number id of the parent span in the whole segment.
     * -1 represents no parent span.
     * Also, be known as the root/first span of the segment.
     * </pre>
     *
     * <code>int32 parentSpanId = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearParentSpanId() {
      
      parentSpanId_ = 0;
      onChanged();
      return this;
    }

    private long startTime_ ;
    /**
     * <pre>
     * Start timestamp in milliseconds of this span,
     * measured between the current time and midnight, January 1, 1970 UTC.
     * </pre>
     *
     * <code>int64 startTime = 3;</code>
     * @return The startTime.
     */
    @java.lang.Override
    public long getStartTime() {
      return startTime_;
    }
    /**
     * <pre>
     * Start timestamp in milliseconds of this span,
     * measured between the current time and midnight, January 1, 1970 UTC.
     * </pre>
     *
     * <code>int64 startTime = 3;</code>
     * @param value The startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTime(long value) {
      
      startTime_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Start timestamp in milliseconds of this span,
     * measured between the current time and midnight, January 1, 1970 UTC.
     * </pre>
     *
     * <code>int64 startTime = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearStartTime() {
      
      startTime_ = 0L;
      onChanged();
      return this;
    }

    private long endTime_ ;
    /**
     * <pre>
     * End timestamp in milliseconds of this span,
     * measured between the current time and midnight, January 1, 1970 UTC.
     * </pre>
     *
     * <code>int64 endTime = 4;</code>
     * @return The endTime.
     */
    @java.lang.Override
    public long getEndTime() {
      return endTime_;
    }
    /**
     * <pre>
     * End timestamp in milliseconds of this span,
     * measured between the current time and midnight, January 1, 1970 UTC.
     * </pre>
     *
     * <code>int64 endTime = 4;</code>
     * @param value The endTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndTime(long value) {
      
      endTime_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * End timestamp in milliseconds of this span,
     * measured between the current time and midnight, January 1, 1970 UTC.
     * </pre>
     *
     * <code>int64 endTime = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearEndTime() {
      
      endTime_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<org.apache.skywalking.apm.network.language.agent.v3.SegmentReference> refs_ =
      java.util.Collections.emptyList();
    private void ensureRefsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        refs_ = new java.util.ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SegmentReference>(refs_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.apache.skywalking.apm.network.language.agent.v3.SegmentReference, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder, org.apache.skywalking.apm.network.language.agent.v3.SegmentReferenceOrBuilder> refsBuilder_;

    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public java.util.List<org.apache.skywalking.apm.network.language.agent.v3.SegmentReference> getRefsList() {
      if (refsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(refs_);
      } else {
        return refsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public int getRefsCount() {
      if (refsBuilder_ == null) {
        return refs_.size();
      } else {
        return refsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.SegmentReference getRefs(int index) {
      if (refsBuilder_ == null) {
        return refs_.get(index);
      } else {
        return refsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder setRefs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference value) {
      if (refsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRefsIsMutable();
        refs_.set(index, value);
        onChanged();
      } else {
        refsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder setRefs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder builderForValue) {
      if (refsBuilder_ == null) {
        ensureRefsIsMutable();
        refs_.set(index, builderForValue.build());
        onChanged();
      } else {
        refsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder addRefs(org.apache.skywalking.apm.network.language.agent.v3.SegmentReference value) {
      if (refsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRefsIsMutable();
        refs_.add(value);
        onChanged();
      } else {
        refsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder addRefs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference value) {
      if (refsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRefsIsMutable();
        refs_.add(index, value);
        onChanged();
      } else {
        refsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder addRefs(
        org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder builderForValue) {
      if (refsBuilder_ == null) {
        ensureRefsIsMutable();
        refs_.add(builderForValue.build());
        onChanged();
      } else {
        refsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder addRefs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder builderForValue) {
      if (refsBuilder_ == null) {
        ensureRefsIsMutable();
        refs_.add(index, builderForValue.build());
        onChanged();
      } else {
        refsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder addAllRefs(
        java.lang.Iterable<? extends org.apache.skywalking.apm.network.language.agent.v3.SegmentReference> values) {
      if (refsBuilder_ == null) {
        ensureRefsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, refs_);
        onChanged();
      } else {
        refsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder clearRefs() {
      if (refsBuilder_ == null) {
        refs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        refsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public Builder removeRefs(int index) {
      if (refsBuilder_ == null) {
        ensureRefsIsMutable();
        refs_.remove(index);
        onChanged();
      } else {
        refsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder getRefsBuilder(
        int index) {
      return getRefsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.SegmentReferenceOrBuilder getRefsOrBuilder(
        int index) {
      if (refsBuilder_ == null) {
        return refs_.get(index);  } else {
        return refsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public java.util.List<? extends org.apache.skywalking.apm.network.language.agent.v3.SegmentReferenceOrBuilder> 
         getRefsOrBuilderList() {
      if (refsBuilder_ != null) {
        return refsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(refs_);
      }
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder addRefsBuilder() {
      return getRefsFieldBuilder().addBuilder(
          org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.getDefaultInstance());
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder addRefsBuilder(
        int index) {
      return getRefsFieldBuilder().addBuilder(
          index, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.getDefaultInstance());
    }
    /**
     * <pre>
     * &lt;Optional&gt;
     * In the across thread and across process, these references targeting the parent segments.
     * The references usually have only one element, but in batch consumer case, such as in MQ or async batch process, it could be multiple.
     * </pre>
     *
     * <code>repeated .skywalking.v3.SegmentReference refs = 5;</code>
     */
    public java.util.List<org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder> 
         getRefsBuilderList() {
      return getRefsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.apache.skywalking.apm.network.language.agent.v3.SegmentReference, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder, org.apache.skywalking.apm.network.language.agent.v3.SegmentReferenceOrBuilder> 
        getRefsFieldBuilder() {
      if (refsBuilder_ == null) {
        refsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.skywalking.apm.network.language.agent.v3.SegmentReference, org.apache.skywalking.apm.network.language.agent.v3.SegmentReference.Builder, org.apache.skywalking.apm.network.language.agent.v3.SegmentReferenceOrBuilder>(
                refs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        refs_ = null;
      }
      return refsBuilder_;
    }

    private java.lang.Object operationName_ = "";
    /**
     * <pre>
     * A logic name represents this span.
     * We don't recommend to include the parameter, such as HTTP request parameters, as a part of the operation, especially this is the name of the entry span.
     * All statistic for the endpoints are aggregated base on this name. Those parameters should be added in the tags if necessary.
     * If in some cases, it have to be a part of the operation name,
     * users should use the Group Parameterized Endpoints capability at the backend to get the meaningful metrics.
     * Read https://github.com/apache/skywalking/blob/master/docs/en/setup/backend/endpoint-grouping-rules.md
     * </pre>
     *
     * <code>string operationName = 6;</code>
     * @return The operationName.
     */
    public java.lang.String getOperationName() {
      java.lang.Object ref = operationName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * A logic name represents this span.
     * We don't recommend to include the parameter, such as HTTP request parameters, as a part of the operation, especially this is the name of the entry span.
     * All statistic for the endpoints are aggregated base on this name. Those parameters should be added in the tags if necessary.
     * If in some cases, it have to be a part of the operation name,
     * users should use the Group Parameterized Endpoints capability at the backend to get the meaningful metrics.
     * Read https://github.com/apache/skywalking/blob/master/docs/en/setup/backend/endpoint-grouping-rules.md
     * </pre>
     *
     * <code>string operationName = 6;</code>
     * @return The bytes for operationName.
     */
    public com.google.protobuf.ByteString
        getOperationNameBytes() {
      java.lang.Object ref = operationName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        operationName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * A logic name represents this span.
     * We don't recommend to include the parameter, such as HTTP request parameters, as a part of the operation, especially this is the name of the entry span.
     * All statistic for the endpoints are aggregated base on this name. Those parameters should be added in the tags if necessary.
     * If in some cases, it have to be a part of the operation name,
     * users should use the Group Parameterized Endpoints capability at the backend to get the meaningful metrics.
     * Read https://github.com/apache/skywalking/blob/master/docs/en/setup/backend/endpoint-grouping-rules.md
     * </pre>
     *
     * <code>string operationName = 6;</code>
     * @param value The operationName to set.
     * @return This builder for chaining.
     */
    public Builder setOperationName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      operationName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A logic name represents this span.
     * We don't recommend to include the parameter, such as HTTP request parameters, as a part of the operation, especially this is the name of the entry span.
     * All statistic for the endpoints are aggregated base on this name. Those parameters should be added in the tags if necessary.
     * If in some cases, it have to be a part of the operation name,
     * users should use the Group Parameterized Endpoints capability at the backend to get the meaningful metrics.
     * Read https://github.com/apache/skywalking/blob/master/docs/en/setup/backend/endpoint-grouping-rules.md
     * </pre>
     *
     * <code>string operationName = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearOperationName() {
      
      operationName_ = getDefaultInstance().getOperationName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A logic name represents this span.
     * We don't recommend to include the parameter, such as HTTP request parameters, as a part of the operation, especially this is the name of the entry span.
     * All statistic for the endpoints are aggregated base on this name. Those parameters should be added in the tags if necessary.
     * If in some cases, it have to be a part of the operation name,
     * users should use the Group Parameterized Endpoints capability at the backend to get the meaningful metrics.
     * Read https://github.com/apache/skywalking/blob/master/docs/en/setup/backend/endpoint-grouping-rules.md
     * </pre>
     *
     * <code>string operationName = 6;</code>
     * @param value The bytes for operationName to set.
     * @return This builder for chaining.
     */
    public Builder setOperationNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      operationName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object peer_ = "";
    /**
     * <pre>
     * Remote address of the peer in RPC/MQ case.
     * This is required when spanType = Exit, as it is a part of the SkyWalking STAM(Streaming Topology Analysis Method).
     * For more details, read https://wu-sheng.github.io/STAM/
     * </pre>
     *
     * <code>string peer = 7;</code>
     * @return The peer.
     */
    public java.lang.String getPeer() {
      java.lang.Object ref = peer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Remote address of the peer in RPC/MQ case.
     * This is required when spanType = Exit, as it is a part of the SkyWalking STAM(Streaming Topology Analysis Method).
     * For more details, read https://wu-sheng.github.io/STAM/
     * </pre>
     *
     * <code>string peer = 7;</code>
     * @return The bytes for peer.
     */
    public com.google.protobuf.ByteString
        getPeerBytes() {
      java.lang.Object ref = peer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        peer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Remote address of the peer in RPC/MQ case.
     * This is required when spanType = Exit, as it is a part of the SkyWalking STAM(Streaming Topology Analysis Method).
     * For more details, read https://wu-sheng.github.io/STAM/
     * </pre>
     *
     * <code>string peer = 7;</code>
     * @param value The peer to set.
     * @return This builder for chaining.
     */
    public Builder setPeer(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      peer_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Remote address of the peer in RPC/MQ case.
     * This is required when spanType = Exit, as it is a part of the SkyWalking STAM(Streaming Topology Analysis Method).
     * For more details, read https://wu-sheng.github.io/STAM/
     * </pre>
     *
     * <code>string peer = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearPeer() {
      
      peer_ = getDefaultInstance().getPeer();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Remote address of the peer in RPC/MQ case.
     * This is required when spanType = Exit, as it is a part of the SkyWalking STAM(Streaming Topology Analysis Method).
     * For more details, read https://wu-sheng.github.io/STAM/
     * </pre>
     *
     * <code>string peer = 7;</code>
     * @param value The bytes for peer to set.
     * @return This builder for chaining.
     */
    public Builder setPeerBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      peer_ = value;
      onChanged();
      return this;
    }

    private int spanType_ = 0;
    /**
     * <pre>
     * Span type represents the role in the RPC context.
     * </pre>
     *
     * <code>.skywalking.v3.SpanType spanType = 8;</code>
     * @return The enum numeric value on the wire for spanType.
     */
    @java.lang.Override public int getSpanTypeValue() {
      return spanType_;
    }
    /**
     * <pre>
     * Span type represents the role in the RPC context.
     * </pre>
     *
     * <code>.skywalking.v3.SpanType spanType = 8;</code>
     * @param value The enum numeric value on the wire for spanType to set.
     * @return This builder for chaining.
     */
    public Builder setSpanTypeValue(int value) {
      
      spanType_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Span type represents the role in the RPC context.
     * </pre>
     *
     * <code>.skywalking.v3.SpanType spanType = 8;</code>
     * @return The spanType.
     */
    @java.lang.Override
    public org.apache.skywalking.apm.network.language.agent.v3.SpanType getSpanType() {
      @SuppressWarnings("deprecation")
      org.apache.skywalking.apm.network.language.agent.v3.SpanType result = org.apache.skywalking.apm.network.language.agent.v3.SpanType.valueOf(spanType_);
      return result == null ? org.apache.skywalking.apm.network.language.agent.v3.SpanType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Span type represents the role in the RPC context.
     * </pre>
     *
     * <code>.skywalking.v3.SpanType spanType = 8;</code>
     * @param value The spanType to set.
     * @return This builder for chaining.
     */
    public Builder setSpanType(org.apache.skywalking.apm.network.language.agent.v3.SpanType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      spanType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Span type represents the role in the RPC context.
     * </pre>
     *
     * <code>.skywalking.v3.SpanType spanType = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearSpanType() {
      
      spanType_ = 0;
      onChanged();
      return this;
    }

    private int spanLayer_ = 0;
    /**
     * <pre>
     * Span layer represent the component tech stack, related to the network tech.
     * </pre>
     *
     * <code>.skywalking.v3.SpanLayer spanLayer = 9;</code>
     * @return The enum numeric value on the wire for spanLayer.
     */
    @java.lang.Override public int getSpanLayerValue() {
      return spanLayer_;
    }
    /**
     * <pre>
     * Span layer represent the component tech stack, related to the network tech.
     * </pre>
     *
     * <code>.skywalking.v3.SpanLayer spanLayer = 9;</code>
     * @param value The enum numeric value on the wire for spanLayer to set.
     * @return This builder for chaining.
     */
    public Builder setSpanLayerValue(int value) {
      
      spanLayer_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Span layer represent the component tech stack, related to the network tech.
     * </pre>
     *
     * <code>.skywalking.v3.SpanLayer spanLayer = 9;</code>
     * @return The spanLayer.
     */
    @java.lang.Override
    public org.apache.skywalking.apm.network.language.agent.v3.SpanLayer getSpanLayer() {
      @SuppressWarnings("deprecation")
      org.apache.skywalking.apm.network.language.agent.v3.SpanLayer result = org.apache.skywalking.apm.network.language.agent.v3.SpanLayer.valueOf(spanLayer_);
      return result == null ? org.apache.skywalking.apm.network.language.agent.v3.SpanLayer.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Span layer represent the component tech stack, related to the network tech.
     * </pre>
     *
     * <code>.skywalking.v3.SpanLayer spanLayer = 9;</code>
     * @param value The spanLayer to set.
     * @return This builder for chaining.
     */
    public Builder setSpanLayer(org.apache.skywalking.apm.network.language.agent.v3.SpanLayer value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      spanLayer_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Span layer represent the component tech stack, related to the network tech.
     * </pre>
     *
     * <code>.skywalking.v3.SpanLayer spanLayer = 9;</code>
     * @return This builder for chaining.
     */
    public Builder clearSpanLayer() {
      
      spanLayer_ = 0;
      onChanged();
      return this;
    }

    private int componentId_ ;
    /**
     * <pre>
     * Component id is a predefinited number id in the SkyWalking.
     * It represents the framework, tech stack used by this tracked span, such as Spring.
     * All IDs are defined in the https://github.com/apache/skywalking/blob/master/oap-server/server-bootstrap/src/main/resources/component-libraries.yml
     * Send a pull request if you want to add languages, components or mapping defintions,
     * all public components could be accepted.
     * Follow this doc for more details, https://github.com/apache/skywalking/blob/master/docs/en/guides/Component-library-settings.md
     * </pre>
     *
     * <code>int32 componentId = 10;</code>
     * @return The componentId.
     */
    @java.lang.Override
    public int getComponentId() {
      return componentId_;
    }
    /**
     * <pre>
     * Component id is a predefinited number id in the SkyWalking.
     * It represents the framework, tech stack used by this tracked span, such as Spring.
     * All IDs are defined in the https://github.com/apache/skywalking/blob/master/oap-server/server-bootstrap/src/main/resources/component-libraries.yml
     * Send a pull request if you want to add languages, components or mapping defintions,
     * all public components could be accepted.
     * Follow this doc for more details, https://github.com/apache/skywalking/blob/master/docs/en/guides/Component-library-settings.md
     * </pre>
     *
     * <code>int32 componentId = 10;</code>
     * @param value The componentId to set.
     * @return This builder for chaining.
     */
    public Builder setComponentId(int value) {
      
      componentId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Component id is a predefinited number id in the SkyWalking.
     * It represents the framework, tech stack used by this tracked span, such as Spring.
     * All IDs are defined in the https://github.com/apache/skywalking/blob/master/oap-server/server-bootstrap/src/main/resources/component-libraries.yml
     * Send a pull request if you want to add languages, components or mapping defintions,
     * all public components could be accepted.
     * Follow this doc for more details, https://github.com/apache/skywalking/blob/master/docs/en/guides/Component-library-settings.md
     * </pre>
     *
     * <code>int32 componentId = 10;</code>
     * @return This builder for chaining.
     */
    public Builder clearComponentId() {
      
      componentId_ = 0;
      onChanged();
      return this;
    }

    private boolean isError_ ;
    /**
     * <pre>
     * The status of the span. False means the tracked execution ends in the unexpected status.
     * This affects the successful rate statistic in the backend.
     * Exception or error code happened in the tracked process doesn't mean isError == true, the implementations of agent plugin and tracing SDK make the final decision.
     * </pre>
     *
     * <code>bool isError = 11;</code>
     * @return The isError.
     */
    @java.lang.Override
    public boolean getIsError() {
      return isError_;
    }
    /**
     * <pre>
     * The status of the span. False means the tracked execution ends in the unexpected status.
     * This affects the successful rate statistic in the backend.
     * Exception or error code happened in the tracked process doesn't mean isError == true, the implementations of agent plugin and tracing SDK make the final decision.
     * </pre>
     *
     * <code>bool isError = 11;</code>
     * @param value The isError to set.
     * @return This builder for chaining.
     */
    public Builder setIsError(boolean value) {
      
      isError_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the span. False means the tracked execution ends in the unexpected status.
     * This affects the successful rate statistic in the backend.
     * Exception or error code happened in the tracked process doesn't mean isError == true, the implementations of agent plugin and tracing SDK make the final decision.
     * </pre>
     *
     * <code>bool isError = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearIsError() {
      
      isError_ = false;
      onChanged();
      return this;
    }

    private java.util.List<org.apache.skywalking.apm.network.common.v3.KeyStringValuePair> tags_ =
      java.util.Collections.emptyList();
    private void ensureTagsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        tags_ = new java.util.ArrayList<org.apache.skywalking.apm.network.common.v3.KeyStringValuePair>(tags_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.apache.skywalking.apm.network.common.v3.KeyStringValuePair, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder, org.apache.skywalking.apm.network.common.v3.KeyStringValuePairOrBuilder> tagsBuilder_;

    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public java.util.List<org.apache.skywalking.apm.network.common.v3.KeyStringValuePair> getTagsList() {
      if (tagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tags_);
      } else {
        return tagsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public int getTagsCount() {
      if (tagsBuilder_ == null) {
        return tags_.size();
      } else {
        return tagsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public org.apache.skywalking.apm.network.common.v3.KeyStringValuePair getTags(int index) {
      if (tagsBuilder_ == null) {
        return tags_.get(index);
      } else {
        return tagsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder setTags(
        int index, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        onChanged();
      } else {
        tagsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder setTags(
        int index, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.set(index, builderForValue.build());
        onChanged();
      } else {
        tagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder addTags(org.apache.skywalking.apm.network.common.v3.KeyStringValuePair value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        onChanged();
      } else {
        tagsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder addTags(
        int index, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(index, value);
        onChanged();
      } else {
        tagsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder addTags(
        org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.add(builderForValue.build());
        onChanged();
      } else {
        tagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder addTags(
        int index, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.add(index, builderForValue.build());
        onChanged();
      } else {
        tagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder addAllTags(
        java.lang.Iterable<? extends org.apache.skywalking.apm.network.common.v3.KeyStringValuePair> values) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, tags_);
        onChanged();
      } else {
        tagsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder clearTags() {
      if (tagsBuilder_ == null) {
        tags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tagsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public Builder removeTags(int index) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.remove(index);
        onChanged();
      } else {
        tagsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder getTagsBuilder(
        int index) {
      return getTagsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public org.apache.skywalking.apm.network.common.v3.KeyStringValuePairOrBuilder getTagsOrBuilder(
        int index) {
      if (tagsBuilder_ == null) {
        return tags_.get(index);  } else {
        return tagsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public java.util.List<? extends org.apache.skywalking.apm.network.common.v3.KeyStringValuePairOrBuilder> 
         getTagsOrBuilderList() {
      if (tagsBuilder_ != null) {
        return tagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tags_);
      }
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder addTagsBuilder() {
      return getTagsFieldBuilder().addBuilder(
          org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.getDefaultInstance());
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder addTagsBuilder(
        int index) {
      return getTagsFieldBuilder().addBuilder(
          index, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.getDefaultInstance());
    }
    /**
     * <pre>
     * String key, String value pair.
     * Tags provides more informance, includes parameters.
     * In the OAP backend analysis, some special tag or tag combination could provide other advanced features.
     * https://github.com/apache/skywalking/blob/master/docs/en/guides/Java-Plugin-Development-Guide.md#special-span-tags
     * </pre>
     *
     * <code>repeated .skywalking.v3.KeyStringValuePair tags = 12;</code>
     */
    public java.util.List<org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder> 
         getTagsBuilderList() {
      return getTagsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.apache.skywalking.apm.network.common.v3.KeyStringValuePair, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder, org.apache.skywalking.apm.network.common.v3.KeyStringValuePairOrBuilder> 
        getTagsFieldBuilder() {
      if (tagsBuilder_ == null) {
        tagsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.skywalking.apm.network.common.v3.KeyStringValuePair, org.apache.skywalking.apm.network.common.v3.KeyStringValuePair.Builder, org.apache.skywalking.apm.network.common.v3.KeyStringValuePairOrBuilder>(
                tags_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        tags_ = null;
      }
      return tagsBuilder_;
    }

    private java.util.List<org.apache.skywalking.apm.network.language.agent.v3.Log> logs_ =
      java.util.Collections.emptyList();
    private void ensureLogsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        logs_ = new java.util.ArrayList<org.apache.skywalking.apm.network.language.agent.v3.Log>(logs_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.apache.skywalking.apm.network.language.agent.v3.Log, org.apache.skywalking.apm.network.language.agent.v3.Log.Builder, org.apache.skywalking.apm.network.language.agent.v3.LogOrBuilder> logsBuilder_;

    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public java.util.List<org.apache.skywalking.apm.network.language.agent.v3.Log> getLogsList() {
      if (logsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(logs_);
      } else {
        return logsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public int getLogsCount() {
      if (logsBuilder_ == null) {
        return logs_.size();
      } else {
        return logsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.Log getLogs(int index) {
      if (logsBuilder_ == null) {
        return logs_.get(index);
      } else {
        return logsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder setLogs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.Log value) {
      if (logsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.set(index, value);
        onChanged();
      } else {
        logsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder setLogs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.Log.Builder builderForValue) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.set(index, builderForValue.build());
        onChanged();
      } else {
        logsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder addLogs(org.apache.skywalking.apm.network.language.agent.v3.Log value) {
      if (logsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.add(value);
        onChanged();
      } else {
        logsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder addLogs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.Log value) {
      if (logsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.add(index, value);
        onChanged();
      } else {
        logsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder addLogs(
        org.apache.skywalking.apm.network.language.agent.v3.Log.Builder builderForValue) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.add(builderForValue.build());
        onChanged();
      } else {
        logsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder addLogs(
        int index, org.apache.skywalking.apm.network.language.agent.v3.Log.Builder builderForValue) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.add(index, builderForValue.build());
        onChanged();
      } else {
        logsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder addAllLogs(
        java.lang.Iterable<? extends org.apache.skywalking.apm.network.language.agent.v3.Log> values) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, logs_);
        onChanged();
      } else {
        logsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder clearLogs() {
      if (logsBuilder_ == null) {
        logs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        logsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public Builder removeLogs(int index) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.remove(index);
        onChanged();
      } else {
        logsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.Log.Builder getLogsBuilder(
        int index) {
      return getLogsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.LogOrBuilder getLogsOrBuilder(
        int index) {
      if (logsBuilder_ == null) {
        return logs_.get(index);  } else {
        return logsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public java.util.List<? extends org.apache.skywalking.apm.network.language.agent.v3.LogOrBuilder> 
         getLogsOrBuilderList() {
      if (logsBuilder_ != null) {
        return logsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(logs_);
      }
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.Log.Builder addLogsBuilder() {
      return getLogsFieldBuilder().addBuilder(
          org.apache.skywalking.apm.network.language.agent.v3.Log.getDefaultInstance());
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public org.apache.skywalking.apm.network.language.agent.v3.Log.Builder addLogsBuilder(
        int index) {
      return getLogsFieldBuilder().addBuilder(
          index, org.apache.skywalking.apm.network.language.agent.v3.Log.getDefaultInstance());
    }
    /**
     * <pre>
     * String key, String value pair with an accurate timestamp.
     * Logging some events happening in the context of the span duration.
     * </pre>
     *
     * <code>repeated .skywalking.v3.Log logs = 13;</code>
     */
    public java.util.List<org.apache.skywalking.apm.network.language.agent.v3.Log.Builder> 
         getLogsBuilderList() {
      return getLogsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.apache.skywalking.apm.network.language.agent.v3.Log, org.apache.skywalking.apm.network.language.agent.v3.Log.Builder, org.apache.skywalking.apm.network.language.agent.v3.LogOrBuilder> 
        getLogsFieldBuilder() {
      if (logsBuilder_ == null) {
        logsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.skywalking.apm.network.language.agent.v3.Log, org.apache.skywalking.apm.network.language.agent.v3.Log.Builder, org.apache.skywalking.apm.network.language.agent.v3.LogOrBuilder>(
                logs_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        logs_ = null;
      }
      return logsBuilder_;
    }

    private boolean skipAnalysis_ ;
    /**
     * <pre>
     * Force the backend don't do analysis, if the value is TRUE.
     * The backend has its own configurations to follow or override this.
     * Use this mostly because the agent/SDK could know more context of the service role.
     * </pre>
     *
     * <code>bool skipAnalysis = 14;</code>
     * @return The skipAnalysis.
     */
    @java.lang.Override
    public boolean getSkipAnalysis() {
      return skipAnalysis_;
    }
    /**
     * <pre>
     * Force the backend don't do analysis, if the value is TRUE.
     * The backend has its own configurations to follow or override this.
     * Use this mostly because the agent/SDK could know more context of the service role.
     * </pre>
     *
     * <code>bool skipAnalysis = 14;</code>
     * @param value The skipAnalysis to set.
     * @return This builder for chaining.
     */
    public Builder setSkipAnalysis(boolean value) {
      
      skipAnalysis_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Force the backend don't do analysis, if the value is TRUE.
     * The backend has its own configurations to follow or override this.
     * Use this mostly because the agent/SDK could know more context of the service role.
     * </pre>
     *
     * <code>bool skipAnalysis = 14;</code>
     * @return This builder for chaining.
     */
    public Builder clearSkipAnalysis() {
      
      skipAnalysis_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:skywalking.v3.SpanObject)
  }

  // @@protoc_insertion_point(class_scope:skywalking.v3.SpanObject)
  private static final org.apache.skywalking.apm.network.language.agent.v3.SpanObject DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new org.apache.skywalking.apm.network.language.agent.v3.SpanObject();
  }

  public static org.apache.skywalking.apm.network.language.agent.v3.SpanObject getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpanObject>
      PARSER = new com.google.protobuf.AbstractParser<SpanObject>() {
    @java.lang.Override
    public SpanObject parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new SpanObject(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<SpanObject> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpanObject> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.skywalking.apm.network.language.agent.v3.SpanObject getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

