/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v21x;

import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.spring.cloud.gateway.v21x.define.EnhanceObjectCache;
import org.reactivestreams.Publisher;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

public class HttpClientFinalizerResponseConnectionInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        final BiFunction finalReceiver = (BiFunction)allArguments[0];
        final EnhanceObjectCache cache = (EnhanceObjectCache)objInst.getSkyWalkingDynamicField();
        allArguments[0] = new BiFunction<HttpClientResponse, Connection, Publisher>(){

            @Override
            public Publisher apply(HttpClientResponse response, Connection connection) {
                Publisher publisher = (Publisher)finalReceiver.apply(response, connection);
                if (cache.getSpan() != null) {
                    if (response.status().code() >= 400) {
                        cache.getSpan().errorOccurred();
                    }
                    Tags.STATUS_CODE.set(cache.getSpan(), String.valueOf(response.status().code()));
                    cache.getSpan().asyncFinish();
                }
                if (cache.getSpan1() != null) {
                    cache.getSpan1().asyncFinish();
                }
                return publisher;
            }
        };
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

