/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.commons;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.SpringMVCPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class RequestUtil {
    public static void collectHttpParam(javax.servlet.http.HttpServletRequest request, AbstractSpan span) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap != null && !parameterMap.isEmpty()) {
            String tagValue = CollectionUtil.toString((Map)parameterMap);
            tagValue = SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD) : tagValue;
            Tags.HTTP.PARAMS.set(span, tagValue);
        }
    }

    public static void collectHttpParam(HttpServletRequest request, AbstractSpan span) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap != null && !parameterMap.isEmpty()) {
            String tagValue = CollectionUtil.toString((Map)parameterMap);
            tagValue = SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD) : tagValue;
            Tags.HTTP.PARAMS.set(span, tagValue);
        }
    }

    public static void collectHttpParam(ServerHttpRequest request, AbstractSpan span) {
        HashMap parameterMap = new HashMap(request.getQueryParams().size());
        request.getQueryParams().forEach((key, value) -> parameterMap.put(key, value.toArray(new String[0])));
        if (!parameterMap.isEmpty()) {
            String tagValue = CollectionUtil.toString(parameterMap);
            tagValue = SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD) : tagValue;
            Tags.HTTP.PARAMS.set(span, tagValue);
        }
    }

    public static void collectHttpHeaders(javax.servlet.http.HttpServletRequest request, AbstractSpan span) {
        ArrayList<String> headersList = new ArrayList<String>(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.size());
        SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.stream().filter(headerName -> request.getHeaders(headerName) != null).forEach(headerName -> {
            Enumeration headerValues = request.getHeaders(headerName);
            ArrayList valueList = Collections.list(headerValues);
            if (!CollectionUtil.isEmpty(valueList)) {
                String headerValue = ((Object)valueList).toString();
                headersList.add(headerName + "=" + headerValue);
            }
        });
        RequestUtil.collectHttpHeaders(headersList, span);
    }

    public static void collectHttpHeaders(HttpServletRequest request, AbstractSpan span) {
        ArrayList<String> headersList = new ArrayList<String>(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.size());
        SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.stream().filter(headerName -> request.getHeaders(headerName) != null).forEach(headerName -> {
            Enumeration headerValues = request.getHeaders(headerName);
            ArrayList valueList = Collections.list(headerValues);
            if (!CollectionUtil.isEmpty(valueList)) {
                String headerValue = ((Object)valueList).toString();
                headersList.add(headerName + "=" + headerValue);
            }
        });
        RequestUtil.collectHttpHeaders(headersList, span);
    }

    public static void collectHttpHeaders(ServerHttpRequest request, AbstractSpan span) {
        ArrayList<String> headersList = new ArrayList<String>(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.size());
        SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.stream().filter(headerName -> RequestUtil.getHeaders(request, headerName).hasMoreElements()).forEach(headerName -> {
            Enumeration<String> headerValues = RequestUtil.getHeaders(request, headerName);
            ArrayList<String> valueList = Collections.list(headerValues);
            if (!CollectionUtil.isEmpty(valueList)) {
                String headerValue = ((Object)valueList).toString();
                headersList.add(headerName + "=" + headerValue);
            }
        });
        RequestUtil.collectHttpHeaders(headersList, span);
    }

    private static void collectHttpHeaders(List<String> headersList, AbstractSpan span) {
        if (headersList != null && !headersList.isEmpty()) {
            String tagValue = String.join((CharSequence)"\n", headersList);
            tagValue = SpringMVCPluginConfig.Plugin.Http.HTTP_HEADERS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)SpringMVCPluginConfig.Plugin.Http.HTTP_HEADERS_LENGTH_THRESHOLD) : tagValue;
            Tags.HTTP.HEADERS.set(span, tagValue);
        }
    }

    public static Enumeration<String> getHeaders(ServerHttpRequest request, String headerName) {
        List values = request.getHeaders().get((Object)headerName);
        if (values == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return Collections.enumeration(values);
    }
}

