/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.commons;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.RequestHolder;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class ReactiveRequestHolder
implements RequestHolder {
    private final ServerHttpRequest serverHttpRequest;

    public ReactiveRequestHolder(ServerHttpRequest serverHttpRequest) {
        this.serverHttpRequest = serverHttpRequest;
    }

    @Override
    public String getHeader(String headerName) {
        return this.serverHttpRequest.getHeaders().getFirst(headerName);
    }

    @Override
    public Enumeration<String> getHeaders(String headerName) {
        return Collections.enumeration(this.serverHttpRequest.getHeaders().get((Object)headerName));
    }

    @Override
    public String requestURL() {
        return this.serverHttpRequest.getURI().toString();
    }

    @Override
    public String requestMethod() {
        return this.serverHttpRequest.getMethodValue();
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(this.serverHttpRequest.getQueryParams().size());
        this.serverHttpRequest.getQueryParams().forEach((key, value) -> parameterMap.put((String)key, value.toArray(new String[0])));
        return parameterMap;
    }
}

